/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.consume.push.platform.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.config.AppPushProperties;
import com.bxm.localnews.mq.consume.push.platform.impl.AbstractPushPlatform;
import com.bxm.localnews.msg.vo.UserDeviceBean;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class HuaweiPushPlatform
extends AbstractPushPlatform {
    @Resource
    private HttpClientService httpClientService;
    @Resource
    private AppPushProperties appPushProperties;
    private String accessToken;
    private long tokenExpiredTime = 0L;

    private void execPush(PushMessage message, JSONArray deviceTokens, List<UserDeviceBean> spiltUserList) {
        if (this.tokenExpiredTime <= System.currentTimeMillis()) {
            this.refreshToken();
        }
        JSONObject param = new JSONObject();
        param.put("appPkgName", (Object)this.appPushProperties.getAppPkgName());
        if (message.getActionType() != null) {
            String intent = "intent://com.bxm.localmastercard/push?message=" + message.getPayloadInfo().toJsonString() + "#Intent;scheme=route;launchFlags=0x20000;end";
            param.put("intent", (Object)intent);
            this.logger.debug("news param:" + intent);
        }
        JSONObject action = new JSONObject();
        if (message.getActionType() != null) {
            action.put("type", (Object)1);
        } else {
            action.put("type", (Object)3);
        }
        action.put("param", (Object)param);
        JSONObject msg = new JSONObject();
        if (TemplateTypeEnum.NOTIFCTION.equals((Object)message.getType())) {
            msg.put("type", (Object)3);
        } else {
            msg.put("type", (Object)1);
        }
        msg.put("action", (Object)action);
        msg.put("body", (Object)JSONObject.toJSONString((Object)message.getPayloadInfo()));
        JSONObject ext = new JSONObject();
        ext.put("biTag", (Object)"Trump");
        JSONObject hps = new JSONObject();
        hps.put("msg", (Object)msg);
        hps.put("ext", (Object)ext);
        JSONObject payload = new JSONObject();
        payload.put("hps", (Object)hps);
        try {
            String postBody = MessageFormat.format("access_token={0}&nsp_svc={1}&nsp_ts={2}&device_token_list={3}&payload={4}", URLEncoder.encode(this.accessToken, "UTF-8"), URLEncoder.encode("openpush.message.api.send", "UTF-8"), URLEncoder.encode(String.valueOf(System.currentTimeMillis() / 1000L), "UTF-8"), URLEncoder.encode(deviceTokens.toString(), "UTF-8"), URLEncoder.encode(payload.toString(), "UTF-8"));
            String postUrl = this.appPushProperties.getHuaweiApiUrl() + "?nsp_ctx=" + URLEncoder.encode("{\"ver\":\"1\", \"appId\":\"" + this.appPushProperties.getHuaweiAppId() + "\"}", "UTF-8");
            String response = this.httpClientService.doPost(postUrl, postBody);
            this.callback(message, spiltUserList, response);
            this.logger.debug("huawei push result:[{}]", (Object)response);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    void singlePush(PushMessage message, UserDeviceBean userDevice) {
        JSONArray deviceTokens = new JSONArray();
        deviceTokens.add((Object)userDevice.getPushToken());
        this.execPush(message, deviceTokens, (List<UserDeviceBean>)ImmutableList.of((Object)userDevice));
    }

    @Override
    void groupPush(PushMessage message, List<UserDeviceBean> userDeviceList) {
        JSONArray deviceTokens = new JSONArray();
        ArrayList spiltUserList = Lists.newArrayList();
        int index = 0;
        for (UserDeviceBean userDevice : userDeviceList) {
            deviceTokens.add((Object)userDevice.getPushToken());
            spiltUserList.add(userDevice);
            if (index != 0 && index % 100 == 0) {
                this.execPush(message, deviceTokens, spiltUserList);
                deviceTokens = new JSONArray();
                spiltUserList = Lists.newArrayList();
            }
            ++index;
        }
        if (userDeviceList.size() % 100 != 0) {
            this.execPush(message, deviceTokens, spiltUserList);
        }
    }

    private void refreshToken() {
        String msgBody = null;
        try {
            msgBody = MessageFormat.format("grant_type=client_credentials&client_secret={0}&client_id={1}", URLEncoder.encode(this.appPushProperties.getHuaweiClientSecret(), "UTF-8"), this.appPushProperties.getHuaweiAppId());
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        String response = this.httpClientService.doPost(this.appPushProperties.getHuaweiAccessTokenUrl(), msgBody);
        JSONObject obj = JSONObject.parseObject((String)response);
        this.tokenExpiredTime = System.currentTimeMillis() + (obj.getLong("expires_in") - 300L) * 1000L;
        this.accessToken = obj.getString("access_token");
    }

    @Override
    public PlatformTypeEnum getType() {
        return PlatformTypeEnum.HUAWEI;
    }
}

