/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.consume.push.platform.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.config.AppPushProperties;
import com.bxm.localnews.mq.consume.push.platform.impl.AbstractPushPlatform;
import com.bxm.localnews.msg.vo.UserDeviceBean;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.Message;
import com.xiaomi.xmpush.server.Result;
import com.xiaomi.xmpush.server.Sender;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.json.simple.parser.ParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class MiuiPushPlatform
extends AbstractPushPlatform {
    private final AppPushProperties appPushProperties;

    @Autowired
    public MiuiPushPlatform(AppPushProperties appPushProperties) {
        this.appPushProperties = appPushProperties;
    }

    @Override
    void singlePush(PushMessage pushMessage, UserDeviceBean userDevice) {
        this.groupPush(pushMessage, (List<UserDeviceBean>)ImmutableList.of((Object)userDevice));
    }

    @Override
    void groupPush(PushMessage pushMessage, List<UserDeviceBean> userDeviceList) {
        String description;
        Constants.useOfficial();
        Sender sender = new Sender(this.appPushProperties.getMiuiAppSecret());
        String title = pushMessage.getTitle();
        if (title.length() > 50) {
            title = title.substring(0, 47) + "...";
        }
        if ((description = pushMessage.getContent()).length() > 128) {
            description = description.substring(0, 128);
        }
        Message.Builder messageBuilder = new Message.Builder().title(title).description(description).timeToLive((long)(pushMessage.getPeriodTime() * 3600000)).payload(JSONObject.toJSONString((Object)pushMessage.getPayloadInfo())).restrictedPackageName(this.appPushProperties.getAppPkgName());
        if (pushMessage.getActionType() != null) {
            String encodeMsg = "";
            try {
                encodeMsg = URLEncoder.encode(pushMessage.getPayloadInfo().toJsonString(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            String intent = "intent:#Intent;component=com.bxm.localmastercard/.ui.push.PushRouteActivity;S.message=" + encodeMsg + ";end";
            this.logger.info("\u63a8\u9001\u62a5\u6587:{}", (Object)intent);
            messageBuilder.extra("notify_effect", "1");
            messageBuilder.extra("intent_uri", intent);
        }
        if (TemplateTypeEnum.NOTIFCTION.equals((Object)pushMessage.getType())) {
            messageBuilder.passThrough(0);
        } else {
            messageBuilder.passThrough(1);
        }
        if (pushMessage.isMute()) {
            messageBuilder.notifyType(Integer.valueOf(0));
        } else if (pushMessage.isShock()) {
            messageBuilder.notifyType(Integer.valueOf(3));
        } else {
            messageBuilder.notifyType(Integer.valueOf(1));
        }
        try {
            ArrayList regIdList = Lists.newArrayList();
            for (UserDeviceBean userDevice : userDeviceList) {
                regIdList.add(userDevice.getPushToken());
            }
            Result result = sender.send(messageBuilder.build(), (List)regIdList, 3);
            this.logger.debug("\u5c0f\u7c73\u63a8\u9001\u5b8c\u6210\uff0c\u63a8\u9001\u7ed3\u679c\uff1a{}", (Object)result);
            this.callback(pushMessage, userDeviceList, result.getErrorCode().getValue() + ":" + result.getReason());
        }
        catch (IOException | ParseException e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    @Override
    public PlatformTypeEnum getType() {
        return PlatformTypeEnum.MIUI;
    }
}

