/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.consume.push.receive;

import com.bxm.localnews.mq.common.constant.PushReceiverRuleEnum;
import com.bxm.localnews.mq.consume.push.receive.IReceiveUserIterator;
import com.bxm.localnews.mq.consume.push.receive.impl.AllReceiveUserIterator;
import com.bxm.localnews.mq.consume.push.receive.impl.AreaReceiveUserIterator;
import com.bxm.localnews.mq.consume.push.receive.impl.AreaVipReceiveUserIterator;
import com.bxm.localnews.mq.consume.push.receive.impl.DefaultUserReceiveUserIterator;
import com.bxm.localnews.msg.domain.UserDeviceMapper;
import com.google.common.collect.Maps;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class ReceiveUserFactory
implements ApplicationListener<ContextRefreshedEvent>,
ApplicationContextAware {
    private final UserDeviceMapper userDeviceMapper;
    private ApplicationContext applicationContext;
    private Map<PushReceiverRuleEnum, IReceiveUserIterator> iteratorMap;

    @Autowired
    public ReceiveUserFactory(UserDeviceMapper userDeviceMapper) {
        this.userDeviceMapper = userDeviceMapper;
    }

    public IReceiveUserIterator get(PushReceiverRuleEnum rule, Map<String, Object> paramMap) {
        return this.iteratorMap.get(rule).build(paramMap).setUserDeviceMapper(this.userDeviceMapper);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.iteratorMap = Maps.newHashMap();
        this.iteratorMap.put(PushReceiverRuleEnum.DEFAULT, new DefaultUserReceiveUserIterator());
        this.iteratorMap.put(PushReceiverRuleEnum.AREA, new AreaReceiveUserIterator());
        this.iteratorMap.put(PushReceiverRuleEnum.ALL, new AllReceiveUserIterator());
        this.iteratorMap.put(PushReceiverRuleEnum.VIP, new AreaVipReceiveUserIterator());
    }
}

