/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.consume.push.receive.impl;

import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.mq.consume.push.receive.IReceiveUserIterator;
import com.bxm.localnews.msg.domain.UserDeviceMapper;
import com.bxm.localnews.msg.vo.UserDeviceBean;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public abstract class AbstractReceiveUserIterator
implements IReceiveUserIterator {
    int pageSize = 1000;
    Map<String, Object> paramMap;
    UserDeviceMapper userDeviceMapper;
    private int total = -1;
    private int currentPage = 0;

    @Override
    public boolean hasNext() {
        if (this.total == -1) {
            this.total = this.getTotal();
        }
        return this.total - this.currentPage * this.pageSize > 0;
    }

    @Override
    public Map<PlatformTypeEnum, List<UserDeviceBean>> next() {
        List<UserDeviceBean> userList = this.queryByPage(this.currentPage);
        HashMap userMap = Maps.newHashMap();
        for (UserDeviceBean user : userList) {
            PlatformTypeEnum type = null;
            type = StringUtils.isEmpty((Object)user.getPlatform()) ? PlatformTypeEnum.GETUI : PlatformTypeEnum.valueOf((String)user.getPlatform());
            List users = (List)userMap.get(type);
            if (null == users) {
                users = Lists.newArrayList();
            }
            users.add(user);
            userMap.put(type, users);
        }
        ++this.currentPage;
        return userMap;
    }

    @Override
    public IReceiveUserIterator setUserDeviceMapper(UserDeviceMapper userDeviceMapper) {
        this.userDeviceMapper = userDeviceMapper;
        return this;
    }

    abstract int getTotal();

    abstract List<UserDeviceBean> queryByPage(int var1);
}

