/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.produce.service.impl;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import com.bxm.localnews.mq.common.constant.AliMqMsgTagEnum;
import com.bxm.localnews.mq.config.AliyunMqProperties;
import com.bxm.localnews.mq.produce.service.AliMqService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class AliMqServiceImpl
implements AliMqService {
    private static final Logger logger = LoggerFactory.getLogger(AliMqServiceImpl.class);
    private AliyunMqProperties aliyunMqProperties;
    private Map<String, Producer> producerBeanMap;
    private ApplicationContext applicationContext;
    @Resource
    private ObjectMapper objectMapper;

    @Autowired
    public AliMqServiceImpl(AliyunMqProperties aliyunMqProperties) {
        this.aliyunMqProperties = aliyunMqProperties;
    }

    @Override
    @Deprecated
    public <T> Message createMessage(String tag, T data) {
        Assert.hasText((String)tag, (String)"tag is blank");
        Assert.notNull(data, (String)"data is null");
        byte[] msgBody = null;
        try {
            msgBody = this.objectMapper.writeValueAsBytes(data);
        }
        catch (JsonProcessingException e) {
            logger.error("CREATE-MSG-ERR", (Throwable)e);
        }
        return new Message(this.aliyunMqProperties.getTopic(), tag, msgBody);
    }

    @Override
    public SendResult send(Message message) {
        Assert.notNull((Object)message, (String)"message is null");
        Assert.hasText((String)message.getTag(), (String)"tag is blank");
        String tag = message.getTag();
        String producerName = AliMqMsgTagEnum.getProducerNameByTag((String)tag);
        return this.producerBeanMap.get(producerName).send(message);
    }

    @Override
    public <T> Message createMessage(AliMqMsgTagEnum tagEnum, T data) {
        Assert.notNull((Object)tagEnum, (String)"tag is blank");
        Assert.notNull(data, (String)"data is null");
        byte[] msgBody = null;
        try {
            msgBody = this.objectMapper.writeValueAsBytes(data);
        }
        catch (JsonProcessingException e) {
            logger.error("CREATE-MSG-ERR", (Throwable)e);
        }
        return new Message(this.chooseTopic(tagEnum.getTag()), tagEnum.getTag(), msgBody);
    }

    private String chooseTopic(String tag) {
        String topicType;
        switch (topicType = AliMqMsgTagEnum.getTopicTypeByTag((String)tag)) {
            case "sms": {
                return this.aliyunMqProperties.getSmsTopic();
            }
            case "push": {
                return this.aliyunMqProperties.getPushTopic();
            }
        }
        return this.aliyunMqProperties.getTopic();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        Map producerMap = this.applicationContext.getBeansOfType(Producer.class);
        this.producerBeanMap = new HashMap<String, Producer>();
        producerMap.forEach((key, value) -> this.producerBeanMap.put((String)key, (Producer)value));
    }
}

