/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.util.DateFormatUtils;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.mq.common.constant.MessageBehaviorEnum;
import com.bxm.localnews.mq.common.constant.MessageTypeEnum;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.PushReceiverRuleEnum;
import com.bxm.localnews.mq.common.constant.UserEventEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.msg.config.MessageTypeProperties;
import com.bxm.localnews.msg.constant.RedisConfig;
import com.bxm.localnews.msg.domain.MessageMapper;
import com.bxm.localnews.msg.dto.MessageType;
import com.bxm.localnews.msg.dto.MessageTypeDTO;
import com.bxm.localnews.msg.event.UserEventService;
import com.bxm.localnews.msg.integration.AdvertIntegrationService;
import com.bxm.localnews.msg.integration.AppVersionIntegrationService;
import com.bxm.localnews.msg.integration.PushTemplateMessageIntegrationService;
import com.bxm.localnews.msg.param.MessageListParam;
import com.bxm.localnews.msg.service.UserMessageService;
import com.bxm.localnews.msg.utils.IntervalPeriodUtils;
import com.bxm.localnews.msg.vo.Tuple;
import com.bxm.localnews.msg.vo.UserMessageBean;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.joda.time.DateTimeComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(rollbackFor={Exception.class})
@RefreshScope
public class UserMessageServiceImpl
implements UserMessageService {
    private static final Logger log = LoggerFactory.getLogger(UserMessageServiceImpl.class);
    private static final String NICKNAME = "nickname";
    private static final String EXTEND = "extend";
    private static final String ACTION = "action";
    private static final String ICON = "icon";
    private static final String EXTEND_CONTENT = "extendContent";
    private static final String EXTEND_URL = "extendUrl";
    private static final String HEAD_IMG = "headImg";
    private static final String CUSTOM_TYPE = "customType";
    @Resource
    private MessageMapper messageMapper;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private AdvertIntegrationService advertIntegrationService;
    @Resource
    private MessageTypeProperties messageTypeProperties;
    @Resource
    private AppVersionIntegrationService appVersionIntegrationService;
    @Resource
    private UserEventService userEventService;
    private DateTimeComparator dateTimeComparator = DateTimeComparator.getInstance();
    @Resource
    private PushTemplateMessageIntegrationService pushTemplateMessageIntegrationService;
    @Resource
    private SequenceCreater sequenceCreater;

    @Override
    public int getUnReadMsg(Long userId, Integer platform, String curVer) {
        Long unread;
        Map<String, Long> unreadNumMap = this.getUnreadMsgNumMap(userId);
        if (platform.intValue() == PlatformEnum.APPLET.getCode()) {
            unreadNumMap.remove(MessageTypeEnum.BALANCE.name());
        } else {
            unreadNumMap.remove(MessageTypeEnum.INVITE.name());
        }
        BasicParam param = new BasicParam();
        param.setCurVer(curVer);
        if (null != curVer && this.appVersionIntegrationService.afterMsgCenterRebuild(param)) {
            unread = 0L;
            for (Map.Entry<String, Long> entry : unreadNumMap.entrySet()) {
                if (NumberUtils.isDigits((String)entry.getKey())) continue;
                unread = unread + entry.getValue();
            }
        } else {
            unread = unreadNumMap.values().stream().mapToLong(v -> v).sum();
        }
        if (log.isDebugEnabled()) {
            log.debug("{}\u5728\u5e73\u53f0{},\u5ba2\u6237\u7aef\u7248\u672c\uff1a{},\u672a\u8bfb\u6d88\u606f\u603b\u6570\u4e3a\uff1a{}", new Object[]{userId, platform, curVer, unread});
        }
        return unread.intValue();
    }

    @Override
    public PageWarper<UserMessageBean> listMessage(MessageListParam messageListParam, BasicParam basicParam) {
        if (MessageTypeEnum.INTERACTION.name().equals(messageListParam.getMessageType())) {
            return new PageWarper((List)Lists.newArrayList());
        }
        this.constructionParam(messageListParam);
        if (CollectionUtils.isEmpty((Collection)messageListParam.getMsgTypeList())) {
            return new PageWarper((List)Lists.newArrayList());
        }
        PageWarper msgPage = new PageWarper(this.messageMapper.listMessage(messageListParam));
        String messageType = messageListParam.getMessageType();
        msgPage.getList().forEach(message -> {
            MessageBehaviorEnum behavior;
            message.setReadStatus(message.getStatus());
            message.setLastTime(DateFormatUtils.format((Date)message.getAddTime()));
            if (NumberUtils.isDigits((String)message.getMsgType()) && null != (behavior = PushMessageEnum.getMessageBehaviorByType((int)Integer.parseInt(message.getMsgType())))) {
                message.setHasDetail(Boolean.valueOf(MessageBehaviorEnum.JUMP.equals((Object)behavior)));
            }
            if (this.messageTypeProperties.isInteraction(messageType)) {
                JSONObject linkParam = JSON.parseObject((String)message.getLinkParam());
                JSONObject extend = linkParam.getJSONObject(EXTEND);
                message.setNickname(extend.getString(NICKNAME));
                message.setAction(extend.getString(ACTION));
                message.setIcon(extend.getString(ICON));
                message.setExtendContent(extend.getString(EXTEND_CONTENT));
                message.setExtendUrl(extend.getString(EXTEND_URL));
            }
        });
        return msgPage;
    }

    @Override
    public MessageTypeDTO getMessageType(String areaCode, Long userId, BasicParam basicParam) {
        MessageTypeDTO msgDto = new MessageTypeDTO();
        ArrayList skipTypes = Lists.newArrayList();
        if (basicParam.getPlatform() == PlatformEnum.APPLET.getCode() || Boolean.TRUE.equals(this.appVersionIntegrationService.getPublishState(basicParam))) {
            skipTypes.add(MessageTypeEnum.BALANCE.name());
        }
        if (basicParam.getPlatform() == PlatformEnum.ANDROID.getCode() || basicParam.getPlatform() == PlatformEnum.IOS.getCode()) {
            skipTypes.add(MessageTypeEnum.INVITE.name());
        }
        this.setMessageList(msgDto, userId, skipTypes, basicParam);
        msgDto.setAdvertDTOS(this.advertIntegrationService.getAdvertByType("10", areaCode, userId));
        return msgDto;
    }

    private void setMessageList(MessageTypeDTO msgDto, Long userId, List<String> skipTypes, BasicParam basicParam) {
        Map<String, Long> unreadNumMap = this.getUnreadMsgNumMap(userId);
        Map<String, MessageType> lastMsgMap = this.getLastMsgMap(userId);
        List msgList = lastMsgMap.values().stream().sorted((pre, next) -> this.dateTimeComparator.compare((Object)next.getSourceLastTime(), (Object)pre.getSourceLastTime())).collect(Collectors.toList());
        ArrayList afterFilter = Lists.newArrayList();
        boolean beforeImVersion = this.appVersionIntegrationService.beforeImVersion(basicParam);
        boolean afterMsgCenterRebuild = this.appVersionIntegrationService.afterMsgCenterRebuild(basicParam);
        for (MessageType msgType : msgList) {
            Long unreadNum;
            boolean showImMsg;
            String type = msgType.getMessageType();
            if (null == type || skipTypes.contains(msgType.getMessageType()) || (showImMsg = (beforeImVersion || afterMsgCenterRebuild) && NumberUtils.isDigits((String)type))) continue;
            if (null != msgType.getSourceLastTime()) {
                msgType.setLastTime(DateFormatUtils.format((Date)msgType.getSourceLastTime()));
            }
            msgType.setUnreadNum(Integer.valueOf((unreadNum = unreadNumMap.get(type)) == null ? 0 : unreadNum.intValue()));
            if (!beforeImVersion) {
                if (MessageTypeEnum.LIKE.name().equals(type)) {
                    msgType.setTitle("\u70b9\u8d5e");
                    msgDto.setLikeType(msgType);
                    continue;
                }
                if (MessageTypeEnum.COMMENT.name().equals(type)) {
                    msgType.setTitle("\u8bc4\u8bba");
                    msgDto.setCommentType(msgType);
                    continue;
                }
                if (MessageTypeEnum.ADD_FUNS.name().equals(type)) {
                    msgType.setTitle("\u65b0\u589e\u7c89\u4e1d");
                    msgDto.setFollowType(msgType);
                    continue;
                }
            } else if (MessageTypeEnum.ADD_FUNS.name().equals(type)) continue;
            MessageType configTypeInfo = this.messageTypeProperties.getMessageInfo(type);
            log.debug("match msg type:{}", (Object)configTypeInfo);
            if (null == configTypeInfo) continue;
            msgType.setTitle(configTypeInfo.getTitle());
            msgType.setImg(configTypeInfo.getImg());
            afterFilter.add(msgType);
        }
        msgDto.setMessageTypes((List)afterFilter);
        this.fillNull(msgDto, beforeImVersion);
    }

    private void fillNull(MessageTypeDTO msgDto, boolean beforeImVersion) {
        if (null == msgDto.getLikeType()) {
            MessageType likeType = new MessageType();
            likeType.setMessageType(MessageTypeEnum.LIKE.name());
            likeType.setTitle("\u70b9\u8d5e");
            likeType.setUnreadNum(Integer.valueOf(0));
            msgDto.setLikeType(likeType);
        }
        if (null == msgDto.getCommentType()) {
            MessageType commentType = new MessageType();
            commentType.setMessageType(MessageTypeEnum.COMMENT.name());
            commentType.setTitle("\u8bc4\u8bba");
            commentType.setUnreadNum(Integer.valueOf(0));
            msgDto.setCommentType(commentType);
        }
        if (null == msgDto.getFollowType()) {
            MessageType followType = new MessageType();
            followType.setMessageType(MessageTypeEnum.ADD_FUNS.name());
            followType.setTitle("\u65b0\u589e\u7c89\u4e1d");
            followType.setUnreadNum(Integer.valueOf(0));
            msgDto.setFollowType(followType);
        }
        if (msgDto.getMessageTypes() == null) {
            msgDto.setMessageTypes((List)Lists.newArrayList());
        }
        for (String type : this.messageTypeProperties.getMessageTypes()) {
            boolean specTypeAndOldVersion = !beforeImVersion && (MessageTypeEnum.LIKE.name().equals(type) || MessageTypeEnum.COMMENT.name().equals(type) || MessageTypeEnum.ADD_FUNS.name().equals(type));
            if (specTypeAndOldVersion || msgDto.getMessageTypes().stream().anyMatch(item -> type.equals(item.getMessageType()))) continue;
            MessageType innerType = new MessageType();
            MessageType configTypeInfo = this.messageTypeProperties.getMessageInfo(type);
            if (null == configTypeInfo) continue;
            innerType.setMessageType(type);
            innerType.setTitle(configTypeInfo.getTitle());
            innerType.setImg(configTypeInfo.getImg());
            msgDto.getMessageTypes().add(innerType);
        }
    }

    private KeyGenerator getUnreadCacheKey(Long userId) {
        return RedisConfig.UN_READ_MSG.copy().appendKey((Object)userId.toString());
    }

    private KeyGenerator getLastMsgCacheKey(Long userId) {
        return RedisConfig.LAST_MSG.copy().appendKey((Object)userId.toString());
    }

    private Map<String, Long> getUnreadMsgNumMap(Long userId) {
        KeyGenerator key = this.getUnreadCacheKey(userId);
        Map<String, Long> result = this.redisHashMapAdapter.entries(key, Long.class);
        if (null == result || result.isEmpty()) {
            result = this.loadHistoryUnread(userId);
            this.redisHashMapAdapter.putAll(key, result);
        }
        return result;
    }

    private Map<String, Long> loadHistoryUnread(Long userId) {
        List unreadTypes = this.messageMapper.getUnreadMap(userId);
        HashMap result = Maps.newHashMap();
        for (Tuple tuple : unreadTypes) {
            String msgType = this.messageTypeProperties.convertType(tuple.getKey());
            Long val = (Long)result.get(msgType);
            val = (val == null ? 0L : val) + (long)tuple.getValue().intValue();
            result.put(msgType, val);
        }
        return result;
    }

    private Map<String, MessageType> getLastMsgMap(Long userId) {
        Map result;
        KeyGenerator key = this.getLastMsgCacheKey(userId);
        if (Boolean.TRUE.equals(this.redisHashMapAdapter.hasKey(key))) {
            result = this.redisHashMapAdapter.entries(key, MessageType.class);
        } else {
            result = this.loadLastMsgHistory(userId);
            this.redisHashMapAdapter.putAll(key, result);
        }
        return result;
    }

    private Map<String, MessageType> loadLastMsgHistory(Long userId) {
        HashMap result = Maps.newHashMap();
        List lastMsgType = this.messageMapper.getLastMsgType(userId);
        List lastIdList = lastMsgType.stream().map(UserMessageBean::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(lastIdList)) {
            return result;
        }
        List lastMessages = this.messageMapper.getLastMsg(userId, lastIdList);
        for (UserMessageBean msg : lastMessages) {
            String msgType = this.messageTypeProperties.convertType(msg.getMsgType());
            MessageType messageType = this.build(msg, msgType);
            result.put(msgType, messageType);
        }
        return result;
    }

    @Override
    public void addUnreadMsg(PushMessage message, Long userId) {
        String msgType = this.messageTypeProperties.convertType(message.getPayloadInfo().getType());
        KeyGenerator key = this.getUnreadCacheKey(userId);
        if (Boolean.FALSE.equals(this.redisHashMapAdapter.hasKey(key))) {
            this.redisHashMapAdapter.putAll(key, this.loadHistoryUnread(userId));
            this.redisHashMapAdapter.expire(key, 604800L);
        }
        this.redisHashMapAdapter.increment(key, msgType, 1);
        this.addMessageTypeLastMsg(message, userId, msgType);
        this.addUnReadUserEvent(userId, msgType);
        if (this.messageTypeProperties.isInteraction(msgType)) {
            this.addInteractionCache(message, userId, msgType);
        }
    }

    @Override
    public void addLastMsg(PushMessage message) {
        Preconditions.checkArgument((null != message ? 1 : 0) != 0);
        Long userId = message.getPushReceiveScope().getUserId();
        String msgType = this.messageTypeProperties.convertType(message.getPayloadInfo().getType());
        this.addMessageTypeLastMsg(message, userId, msgType);
    }

    private void addInteractionCache(PushMessage message, Long userId, String msgType) {
        int index = IntervalPeriodUtils.getIntervalIndex();
        KeyGenerator key = RedisConfig.LAST_INTERACTION_MSG.copy().appendKey((Object)index).appendKey((Object)msgType);
        this.redisHashMapAdapter.put(key, userId.toString(), (Object)message);
        this.redisHashMapAdapter.expire(key, 3600L);
        key = RedisConfig.INTERACTION_NUM.copy().appendKey((Object)index).appendKey((Object)msgType);
        this.redisHashMapAdapter.increment(key, userId.toString(), 1);
        this.redisHashMapAdapter.expire(key, 3600L);
    }

    private void removeInteractionCache(Long userId, String msgType) {
        int index = IntervalPeriodUtils.getIntervalIndex();
        KeyGenerator key = RedisConfig.LAST_INTERACTION_MSG.copy().appendKey((Object)index).appendKey((Object)msgType);
        this.redisHashMapAdapter.remove(key, new String[]{userId.toString()});
        key = RedisConfig.INTERACTION_NUM.copy().appendKey((Object)index).appendKey((Object)msgType);
        this.redisHashMapAdapter.put(key, userId.toString(), (Object)0);
    }

    private MessageType build(UserMessageBean message, String msgType) {
        MessageType messageType = new MessageType();
        messageType.setMessageType(msgType);
        messageType.setSourceLastTime(message.getAddTime());
        if (this.messageTypeProperties.isInteraction(msgType)) {
            JSONObject extend = JSON.parseObject((String)message.getLinkParam());
            String nickName = Objects.toString(extend.get((Object)NICKNAME), "");
            String action = Objects.toString(extend.get((Object)ACTION), "");
            messageType.setDescription(nickName + action);
        } else {
            messageType.setDescription(message.getContent());
        }
        return messageType;
    }

    private void addMessageTypeLastMsg(PushMessage message, Long userId, String msgType) {
        Map extend;
        MessageType entity = new MessageType();
        KeyGenerator key = this.getLastMsgCacheKey(userId);
        if (Boolean.FALSE.equals(this.redisHashMapAdapter.hasKey(key))) {
            Map<String, MessageType> historyMap = this.loadLastMsgHistory(userId);
            this.redisHashMapAdapter.putAll(key, historyMap);
            this.redisHashMapAdapter.expire(key, 604800L);
        }
        if (this.messageTypeProperties.isInteraction(msgType)) {
            extend = message.getPayloadInfo().getExtend();
            String nickName = Objects.toString(extend.get(NICKNAME), "");
            String action = Objects.toString(extend.get(ACTION), "");
            entity.setDescription(nickName + action);
        } else {
            entity.setDescription(message.getContent());
        }
        if (PushMessageEnum.IM_MESSAGE.name().equals(msgType)) {
            extend = message.getPayloadInfo().getExtend();
            String nickname = Objects.toString(extend.get(NICKNAME), "");
            String headImg = Objects.toString(extend.get(HEAD_IMG), "");
            String customType = Objects.toString(extend.get(CUSTOM_TYPE), "");
            entity.setImg(headImg);
            entity.setTitle(nickname);
            entity.setMessageType(customType);
            msgType = customType;
        }
        entity.setSourceLastTime(new Date());
        entity.setMessageType(msgType);
        this.redisHashMapAdapter.put(key, msgType, (Object)entity);
    }

    @Override
    public void updateMessageByType(Long userId, String messageType) {
        if (!NumberUtils.isDigits((String)messageType) && !MessageTypeEnum.ADD_FUNS.name().equals(messageType)) {
            MessageListParam messageListParam = new MessageListParam();
            messageListParam.setUserId(userId);
            messageListParam.setMessageType(messageType);
            this.constructionParam(messageListParam);
            this.messageMapper.updateMessageByType(messageListParam);
        }
        this.redisHashMapAdapter.put(this.getUnreadCacheKey(userId), messageType, (Object)0L);
        if (this.messageTypeProperties.isInteraction(messageType)) {
            this.removeInteractionCache(userId, messageType);
        }
        this.addUnReadUserEvent(userId, messageType);
    }

    @Override
    public void addMessage(PushMessage message, Long userId) {
        UserMessageBean entity = new UserMessageBean();
        entity.setId(this.sequenceCreater.nextLongId());
        entity.setTitle(message.getTitle());
        entity.setContent(message.getContent());
        entity.setUserId(userId);
        entity.setMsgType(String.valueOf(message.getPayloadInfo().getType()));
        entity.setStatus(Byte.valueOf((byte)0));
        entity.setLinkParam(JSON.toJSONString((Object)message.getPayloadInfo()));
        entity.setAddTime(new Date());
        this.addUnreadMsg(message, userId);
        if (message.isPersistence()) {
            this.messageMapper.insertSelective(entity);
        }
    }

    @Override
    public Map<String, Long> getUnReadNum(Long userId, String messageType) {
        HashMap resultMap = Maps.newHashMap();
        Map<String, Long> unReadMap = this.getUnreadMsgNumMap(userId);
        if (StringUtils.isBlank((String)messageType)) {
            return resultMap;
        }
        if (!unReadMap.containsKey(messageType)) {
            return resultMap;
        }
        resultMap.put(messageType, unReadMap.get(messageType));
        return this.getUnreadMsgNumMap(userId);
    }

    private void addUnReadUserEvent(Long userId, String msgType) {
        if (!(MessageTypeEnum.BALANCE.name().equals(msgType) || MessageTypeEnum.INVITE.name().equals(msgType) || PushMessageEnum.IM_MESSAGE.name().equals(msgType))) {
            this.userEventService.add(this.buildSystemPush(userId));
        }
    }

    private PushPayloadInfo buildSystemPush(Long userId) {
        return PushPayloadInfo.build().setType(UserEventEnum.UN_READ_SYSTEM_MSG.type).addExtend("userId", (Object)userId).addExtend("current", (Object)this.getUnReadMsg(userId, 0, "3.0.0"));
    }

    @Deprecated
    private PushPayloadInfo buildPushPayloadInfo(Long userId) {
        return PushPayloadInfo.build().setType(UserEventEnum.USER_UN_READ_MSG.type).addExtend("userId", (Object)userId).addExtend("current", (Object)this.getUnReadMsg(userId, 0, null));
    }

    @Deprecated
    private PushPayloadInfo buildAppletPushPayloadInfo(Long userId) {
        return PushPayloadInfo.build().setType(UserEventEnum.APPLET_USER_UN_READ_MSG.type).addExtend("userId", (Object)userId).addExtend("current", (Object)this.getUnReadMsg(userId, 5, null));
    }

    private void pushTemplateMessage(PushMessage pushMessage, Long userId) {
        int type = pushMessage.getPayloadInfo().getType();
        if (this.messageTypeProperties.getTemplate().contains(type)) {
            PushMessage cloneMsg = PushMessage.build();
            BeanUtils.copyProperties((Object)pushMessage, (Object)cloneMsg);
            cloneMsg.setPushReceiveScope(PushReceiveScope.pushRule((PushReceiverRuleEnum)PushReceiverRuleEnum.DEFAULT).addRuleParam("userIds", (Object)userId));
            this.pushTemplateMessageIntegrationService.pushTemplateMessage(cloneMsg);
        }
    }

    private void constructionParam(MessageListParam param) {
        if (StringUtils.isNotEmpty((String)param.getMessageType()) && MessageTypeEnum.INTERACTION.name().equals(param.getMessageType())) {
            List<String> msgTypeList = this.messageTypeProperties.getSubTypes(MessageTypeEnum.COMMENT.name());
            msgTypeList.addAll(this.messageTypeProperties.getSubTypes(MessageTypeEnum.LIKE.name()));
            param.setMsgTypeList(msgTypeList);
        } else {
            param.setMsgTypeList(this.messageTypeProperties.getSubTypes(param.getMessageType()));
        }
    }
}

