/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.controller;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipaySignature;
import com.bxm.localnews.payment.config.AlipayProperties;
import com.bxm.localnews.payment.constant.PayTypeEnum;
import com.bxm.localnews.payment.proxy.PayProxyService;
import com.bxm.newidea.component.controller.BaseController;
import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"6-02 \u652f\u4ed8\u56de\u8c03\u76f8\u5173\u63a5\u53e3"}, description="\u5305\u62ec\u652f\u4ed8\u56de\u8c03\u63a5\u53e3\u64cd\u4f5c")
@ApiIgnore
@RestController
@RequestMapping(value={"/api/notify"})
@RefreshScope
public class PayNotifyController
extends BaseController {
    private PayProxyService payProxyService;
    private AlipayProperties alipayProperties;

    @Autowired
    public PayNotifyController(PayProxyService payProxyService, AlipayProperties alipayProperties) {
        this.payProxyService = payProxyService;
        this.alipayProperties = alipayProperties;
    }

    @ApiOperation(value="\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u5904\u7406", notes="")
    @PostMapping(value={"/wechat"})
    public String parseOrderNotifyResult(@RequestBody String xmlData) {
        return WxPayNotifyResponse.success((String)"\u6210\u529f");
    }

    @ApiOperation(value="\u652f\u4ed8\u5b9d\u56de\u8c03\u901a\u77e5\u5904\u7406", notes="")
    @PostMapping(value={"/alipay"})
    public void aliPayNotifyResult(HttpServletRequest request, HttpServletResponse response) {
        try {
            PrintWriter writer = response.getWriter();
            if (this.verifyResult(request).booleanValue()) {
                this.logger.info("\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u9a8c\u8bc1\u6210\u529f");
                this.payProxyService.notifyPay(this.mapToString(request), PayTypeEnum.ALI_PAY);
                writer.print("success");
            } else {
                this.logger.info("\u652f\u4ed8\u5b9d\u56de\u8c03\u901a\u77e5\u9a8c\u8bc1\u5931\u8d25");
                writer.print("fail");
            }
        }
        catch (AlipayApiException e) {
            this.logger.error("\u652f\u4ed8\u5b9d\u56de\u8c03\u901a\u77e5\uff1a\u6570\u636e\u89e3\u6790\u5f02\u5e38: {}", (Throwable)e);
        }
        catch (IOException ioe) {
            this.logger.error("response\u83b7\u53d6writer\u5f02\u5e38:{}", (Throwable)ioe);
        }
    }

    @ApiOperation(value="\u652f\u4ed8\u5b9d\u56de\u8c03\u901a\u77e5\u5904\u7406(\u9884\u53d1\u5e03\u73af\u5883\u652f\u6301\u7528)")
    @PostMapping(value={"pre/alipay"})
    public void alipayNodifyPreResult(HttpServletRequest request, HttpServletResponse response) {
        this.aliPayNotifyResult(request, response);
    }

    private String mapToString(HttpServletRequest request) {
        try {
            HashMap map = Maps.newHashMap();
            String outTradeNo = new String(request.getParameter("out_trade_no").getBytes("ISO-8859-1"), "UTF-8");
            String tradeStatus = new String(request.getParameter("trade_status").getBytes("ISO-8859-1"), "UTF-8");
            map.put("outTradeNo", outTradeNo);
            map.put("tradeStatus", tradeStatus);
            String notifyTime = new String(request.getParameter("notify_time").getBytes("ISO-8859-1"), "UTF-8");
            map.put("notifyTime", notifyTime);
            return JSONObject.toJSONString((Object)map);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("\u7f16\u7801\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38: {}", (Throwable)e);
            return null;
        }
    }

    private Map<String, String> covertMap(HttpServletRequest request) {
        HashMap map = Maps.newHashMap();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
            }
            map.put(name, valueStr);
        }
        this.logger.info("\u652f\u4ed8\u5b9d\u5f02\u6b65\u901a\u77e5\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)map));
        return map;
    }

    private Boolean verifyResult(HttpServletRequest request) throws AlipayApiException {
        return AlipaySignature.rsaCheckV1(this.covertMap(request), (String)this.alipayProperties.getAlipayPublicKey(), (String)this.alipayProperties.getCharset(), (String)this.alipayProperties.getSigntype());
    }
}

