package com.bxm.localnews.payment.controller;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.payment.dto.WithdrawDTO;
import com.bxm.localnews.payment.param.UserWithdrawParam;
import com.bxm.localnews.payment.service.UserWithdrawService;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;

/**
 * @author zhaoyadong 2019/3/11 10:07
 * @desc
 */
@Api(tags = "6-03 提现相关接口")
@RestController
@RequestMapping("api/user/withdraw")
public class UserWithdrawController {

    private final UserWithdrawService userWithdrawService;

    @Autowired
    public UserWithdrawController(UserWithdrawService userWithdrawService) {
        this.userWithdrawService = userWithdrawService;
    }

    @ApiOperation(value = "6-03-1 [已废弃]用户发起提现", notes = "用户账户余额提现，修改为6-03-3", hidden = true)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id"),
            @ApiImplicitParam(name = "amount", value = "提现金额")
    })
    @PostMapping("")
    @Deprecated
    public Json<BigDecimal> userWithDraw(@RequestParam("userId") Long userId,
                                         @RequestParam("amount") BigDecimal amount,
                                         BasicParam basicParam,
                                         HttpServletRequest request) {
        return Json.build(userWithdrawService.userWithdraw(userId,
                amount,
                basicParam.getDevcId(),
                WebUtils.getIpAddr(request),
                basicParam.getPlatform()));
    }

    @ApiOperation(value = "6-03-2 获取可提现列表", notes = "获取当前用户可提现列表，根据不同的业务场景返回的列表有区别")
    @ApiImplicitParam(name = "userId", value = "当前用户ID", required = true)
    @GetMapping("list")
    public ResponseJson<WithdrawDTO> getWithdrawList(@RequestParam("userId") Long userId) {
        return ResponseJson.ok(userWithdrawService.getWithdrwaOptions(userId));
    }

    @ApiOperation(value = "6-03-3 用户发起提现", notes = "根据可提现列表发起提现，不需要提供具体的提现金额")
    @PostMapping("submit")
    public ResponseJson withdrwa(@RequestBody UserWithdrawParam param, HttpServletRequest request) {
        param.setRequestIp(WebUtils.getIpAddr(request));

        return ResponseJson.build(userWithdrawService.execWithdraw(param));
    }
}
