package com.bxm.localnews.payment.domain;

import com.bxm.localnews.payment.vo.WithdrawFlow;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author zhaoyadong 2019/3/6 13:51
 * @desc
 */
@Mapper
public interface WithdrawMapper {

    /**
     * 获取用户最后一笔提现信息
     *
     * @param userId
     * @return
     */
    WithdrawFlow getUserLastWithdraw(@Param("userId") Long userId);

    int addWithdrawFlow(WithdrawFlow withdrawFlow);

    int updateWithdrawFlow(WithdrawFlow withdrawFlow);

    List<WithdrawFlow> queryWithdraw();

    /**
     * 统计时间段内的提现总额
     *
     * @param startTime
     * @param endTime
     * @return
     */
    BigDecimal countWithdrawAmount(@Param("startTime") String startTime, @Param("endTime") String endTime);

    /**
     * 统计时间段内的成功提现总额
     *
     * @param startTime
     * @param endTime
     * @return
     */
    BigDecimal countSuccessWithdrawAmount(@Param("startTime") String startTime, @Param("endTime") String endTime);

    /**
     * 统计对应时间段内的提现人数
     *
     * @param startTime
     * @param endTime
     * @return
     */
    int countNumber(@Param("startTime") String startTime, @Param("endTime") String endTime);

}
