package com.bxm.localnews.payment.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;

@ApiModel(description = "提现信息")
@Data
@Builder
public class WithdrawConfigDTO {
    @Tolerate
    public WithdrawConfigDTO() {
    }

    @ApiModelProperty("提现选项对应的ID")
    private Long withdrawId;

    @ApiModelProperty("金额")
    private BigDecimal amount;

    @ApiModelProperty("可提现次数")
    private Integer withdrawNumber;

    @ApiModelProperty("是否可以提现")
    private Boolean enableWithdraw;
}
