package com.bxm.localnews.payment.param;

import com.bxm.newidea.component.vo.BasicParam;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "用户业务订单参数")
@Data
public class UserOrderParam extends BasicParam {

    @ApiModelProperty(value = "下单用户ID", required = true)
    @NotNull
    private Long userId;

    @ApiModelProperty(value = "支付方式,1:微信支付，2：支付宝支付，3：微信JS-API支付", allowableValues = "1,2,3", required = true)
    @NotNull
    private Byte payType;

    @ApiModelProperty("支付成功后的跳转地址")
    private String returnUrl;

    @ApiModelProperty(value = "订单类型，" +
            "welfareVip : 福利VIP卡（3.2.0新版本）," +
            "localVip ：VIP卡（历史版本）" +
            "redPacket : 口令红包", required = true)
    private String orderType;

    @ApiModelProperty("微信code，微信jsapi支付时需要提供")
    private String wechatCode;

    @ApiModelProperty("创建的支付订单相关联的业务ID，选填")
    private Long bizId;

    @ApiModelProperty(value = "支付金额，兼容历史接口，不对外暴露，也不提倡使用", hidden = true)
    @JsonIgnore
    @Deprecated
    private BigDecimal amount;

    @ApiModelProperty(value = "请求来源IP", hidden = true)
    @JsonIgnore
    private String requestIp;
    @ApiModelProperty("分享人的id")
    private String inviterId;
}

