package com.bxm.localnews.payment.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(description = "订单详细信息")
@Data
public class PaymentOrderDetail extends PaymentOrder {

    @ApiModelProperty(value = "付款链接")
    private String link;

    @ApiModelProperty(value = "跳转链接")
    private String returnUrl;

    @ApiModelProperty(value = "微信授权码")
    private String authCode;

    @ApiModelProperty(value = "当前支付对应的appid，js-api特有参数")
    private String appId;

    @ApiModelProperty(value = "时间戳参数，js-api特有参数")
    private String timeStamp;

    @ApiModelProperty(value = "随机码，js-api特有参数")
    private String nonceStr;

    @ApiModelProperty(value = "js-api特有参数")
    private String packageValue;

    @ApiModelProperty(value = "签名类型，js-api特有参数")
    private String signType;

    @ApiModelProperty(value = "支付签名，js-api特有参数")
    private String paySign;
}
