package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.common.constant.ErrorCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.domain.AdvertMapper;
import com.bxm.localnews.thirdparty.domain.AdvertStatisticMapper;
import com.bxm.localnews.thirdparty.vo.Advert;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * Created by hsq 17:37 2018/5/23
 */
@Api(tags = "3-01 广告接口", description = "广告接口相关操作")
@RestController
@RequestMapping("api/advert")
public class AdvertController {

    private AdvertStatisticMapper advertStatisticMapper;

    private AdvertMapper advertMapper;

    @Autowired
    public AdvertController(AdvertStatisticMapper advertStatisticMapper, AdvertMapper advertMapper){
        this.advertStatisticMapper = advertStatisticMapper;
        this.advertMapper = advertMapper;
    }

    @ApiOperation(value = "3-01-1 点击广告", notes = "")
    @ApiImplicitParam(name = "advertId", value = "广告id")
    @RequestMapping(value = "click", method = RequestMethod.POST)
    public Json addClicks(Long advertId) {
        Advert advert = this.advertMapper.selectByPrimaryKey(advertId);
        if (advert != null) {
            this.advertStatisticMapper.addClicks(advertId);
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult(ErrorCode.PARAM_ERR, "广告不存在");
    }

    @ApiOperation(value = "3-01-2 广告展示", notes = "")
    @ApiImplicitParam(name = "advertId", value = "广告id")
    @RequestMapping(value = "show", method = RequestMethod.POST)
    public Json addShows(Long advertId) {
        Advert advert = this.advertMapper.selectByPrimaryKey(advertId);
        if (advert != null) {
            this.advertStatisticMapper.addShows(advertId);
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult(ErrorCode.PARAM_ERR, "广告不存在");
    }

}
