package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.service.PayKnowledgeService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "3-06 知识付费相关接口", description = "知识付费相关接口")
@RestController
@RequestMapping("/api/amount")
public class PayKnowledgeController {

    private PayKnowledgeService payKnowledgeService;

    @Autowired
    public PayKnowledgeController(PayKnowledgeService payKnowledgeService) {
        this.payKnowledgeService = payKnowledgeService;
    }

    @ApiOperation(value = "3-06-1 知识付费首页免登陆url", notes = "")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @RequestMapping(value = "/exempt/knowledge/login", method = RequestMethod.GET)
    public Json<String> exemptKnowledgeLogin(@RequestParam(value = "userId") Long userId) {
        return this.payKnowledgeService.exemptPayKnowledgeLogin(userId);
    }
}
