package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.dto.OperateUserPointDTO;
import com.bxm.localnews.thirdparty.dto.PointStoreBaseDTO;
import com.bxm.localnews.thirdparty.dto.UserPointDTO;
import com.bxm.localnews.thirdparty.service.PointStoreService;
import com.bxm.localnews.user.param.DeductPointParam;
import com.bxm.localnews.user.param.StoreNeceParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "3-08 积分商城相关接口", description = "积分商城相关接口操作")
@RestController
@RequestMapping("api/amount")
public class PointStoreController {

    private PointStoreService pointStoreService;

    @Autowired
    public PointStoreController(PointStoreService pointStoreService) {
        this.pointStoreService = pointStoreService;
    }

    @ApiOperation(value = "3-08-1 商城首页免登陆url", notes = "")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @RequestMapping(value = "/exempt/login", method = RequestMethod.GET)
    public Json<String> exemptLogin(@RequestParam(value = "userId") Long userId) {
        return this.pointStoreService.exemptLogin(userId);
    }

    @ApiOperation(value = "3-08-2 商品免登陆url", notes = "")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID"),
            @ApiImplicitParam(name = "orderNo", value = "商品名称:分别为：didi表示滴滴打车券，jiayou表示加油卡免费券, " +
                    "hongbao表示拼多多红包，shentiru表示免费领取身体乳，4表示幸运大转盘")
    })
    @RequestMapping(value = "/exempt/goods/login", method = RequestMethod.GET)
    public Json<String> exemptGoodsLogin(@RequestParam(value = "userId") Long userId,
                                         @RequestParam(value = "orderNo") String orderNo) {
        return this.pointStoreService.exemptGoodsLogin(userId, orderNo);
    }

    @ApiOperation(value = "3-08-3 用户金币信息", notes = "")
    @RequestMapping(value = "/balance", method = RequestMethod.GET)
    public UserPointDTO userBalance(StoreNeceParam storeNeceParam) {
        return this.pointStoreService.selectJbBalanceByUserId(storeNeceParam);
    }

    @ApiOperation(value = "3-08-4 扣除用户金币", notes = "")
    @RequestMapping(value = "/deduct/balance", method = RequestMethod.POST)
    public OperateUserPointDTO deductBalance(DeductPointParam deductPointParam) {
        return this.pointStoreService.deductUserBalance(deductPointParam);
    }

    @ApiOperation(value = "3-08-5 确认扣除用户金币", notes = "")
    @RequestMapping(value = "/confirm/deduct/balance", method = RequestMethod.POST)
    public PointStoreBaseDTO deductConfirmBalance(DeductPointParam deductPointParam) {
        return this.pointStoreService.deductConfirmUserBalance(deductPointParam);
    }

    @ApiOperation(value = "3-08-6 添加用户金币", notes = "")
    @RequestMapping(value = "/balance", method = RequestMethod.POST)
    public OperateUserPointDTO addUserBalance(DeductPointParam deductPointParam) {
        return this.pointStoreService.addUserBalance(deductPointParam);
    }
}
