/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import com.bxm.newidea.component.tools.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipFile;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(tags={"3-02 \u8d44\u6e90\u4e0b\u8f7d"}, description="\u5305\u62ec\u63d0\u4f9bandriod\u7684\u81ea\u5b9a\u4e49\u5305\u4e0b\u8f7d\u6d41")
@Controller
@RefreshScope
@RequestMapping(value={"api/download"})
public class AndriodDownloadController
extends BaseController {
    private BizConfigProperties bizConfigProperties;

    @Autowired
    public AndriodDownloadController(BizConfigProperties bizConfigProperties) {
        this.bizConfigProperties = bizConfigProperties;
    }

    @ApiOperation(value="3-02-1 \u5b89\u5353\u5b89\u88c5\u5305\u4e0b\u8f7d", notes="\u6839\u636e\u9080\u8bf7\u7801\u8fd4\u56de\u5e26\u6709\u9080\u8bf7\u7801\u4fe1\u606f\u7684\u5b89\u5353\u5b89\u88c5\u5305\uff0c\u5b89\u88c5\u5305\u4e2d\u7684\u989d\u5916\u5185\u5bb9\u4e3aic={\u9080\u8bf7\u7801}")
    @ApiImplicitParam(name="inviteCode", value="\u9080\u8bf7\u7801(userId)", paramType="path", dataType="String", required=true)
    @RequestMapping(value={"/andriod/{inviteCode}"}, method={RequestMethod.GET})
    public void andriod(@PathVariable String inviteCode, HttpServletResponse response) throws IOException {
        this.processDownload("\u672c\u5730\u4e07\u4e8b\u901a.apk", response);
        this.writeApk(this.getApkFile(), inviteCode, (OutputStream)response.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeApk(File file, String comment, OutputStream outputStream) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            String zipComment = zipFile.getComment();
            if (zipComment != null) {
                return;
            }
            byte[] byteComment = comment.getBytes();
            byteComment = ArrayUtils.addAll((byte[])byteComment, (byte[])BitOperatorUtil.short2Byte((short)((short)byteComment.length)));
            IOUtils.copyLarge((InputStream)new FileInputStream(file), (OutputStream)outputStream, (long)0L, (long)(file.length() - 2L));
            IOUtils.write((byte[])BitOperatorUtil.short2Byte((short)((short)byteComment.length)), (OutputStream)outputStream);
            IOUtils.write((byte[])byteComment, (OutputStream)outputStream);
            outputStream.flush();
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private File getApkFile() {
        boolean result;
        File appFile;
        String lastVersion = this.bizConfigProperties.getInviteAndriodApkUrl();
        String fileName = StringUtils.substringAfterLast((String)lastVersion, (String)"/");
        String separator = "";
        if (!this.bizConfigProperties.getTempDir().endsWith("/") && !this.bizConfigProperties.getTempDir().endsWith("\\")) {
            separator = File.separator;
        }
        if ((appFile = new File(this.bizConfigProperties.getTempDir() + separator + fileName)).exists()) {
            return appFile;
        }
        File tempDirFile = new File(this.bizConfigProperties.getTempDir());
        if (!tempDirFile.exists() && !(result = tempDirFile.mkdirs())) {
            this.logger.error("\u521b\u5efa[{}]\u76ee\u5f55\u5931\u8d25\uff0c\u53ef\u80fd\u6ca1\u6709\u6743\u9650", (Object)this.bizConfigProperties.getTempDir());
        }
        try {
            FileUtils.copyURLToFile((URL)new URL(lastVersion), (File)appFile);
        }
        catch (IOException e) {
            this.logger.error("\u53c2\u6570[common.config.invite-andriod-apk-url]\u914d\u7f6e\u7684\u5b89\u5353\u4e0b\u8f7d\u6587\u4ef6\u8def\u5f84\u4e0d\u6b63\u786e", (Throwable)e);
        }
        return appFile;
    }
}

