/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.controller;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.thirdparty.config.WechatProperties;
import com.bxm.localnews.thirdparty.service.CrmSendMessageService;
import com.bxm.localnews.thirdparty.service.WechatService;
import com.bxm.localnews.thirdparty.wxmessage.MediaContent;
import com.bxm.localnews.thirdparty.wxmessage.Message;
import com.bxm.localnews.thirdparty.wxmessage.TextContent;
import com.qq.weixin.mp.aes.AesException;
import com.qq.weixin.mp.aes.SHA1;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"api/public/callBack"})
@ApiIgnore
public class CallBackController {
    private Logger LOG = LoggerFactory.getLogger(CallBackController.class);
    @Autowired
    private WechatProperties wechatProperties;
    @Autowired
    private WechatService wechatService;
    @Autowired
    private CrmSendMessageService crmSendMessageService;

    @ApiOperation(value="\u63a5\u6536\u5ba2\u670d\u6d88\u606f", notes="\u63a5\u6536\u5ba2\u670d\u6d88\u606f\u5e76\u81ea\u52a8\u56de\u590d")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public String callBack(@RequestBody JSONObject body) throws Exception {
        String fromUserName = body.getString("FromUserName");
        this.LOG.info("\u5ba2\u670d\u6d88\u606f\u53d1\u9001 fromUserName:{}", (Object)fromUserName);
        String msgId = body.getString("MsgId");
        if (StringUtils.isNotBlank((CharSequence)msgId)) {
            this.sendMessage(fromUserName, "\u6233\u94fe\u63a5\u4e0b\u8f7dApp\uff0c\u7acb\u5373\u63d0\u73b0" + this.wechatProperties.getDownloadUrl() + "\uff0c\u66f4\u591a\u73b0\u91d1\u7ea2\u5305\u7b49\u4f60\u6765\u9886", null);
        }
        return "";
    }

    private void sendMessage(String FromUserName, String textContent, String imageId) throws Exception {
        Message messageText = new Message();
        TextContent text = new TextContent();
        text.setContent(textContent);
        messageText.setMsgtype("text");
        messageText.setText(text);
        messageText.setTouser(FromUserName);
        this.crmSendMessageService.sendMessageOfText(this.wechatService.getWeChatToken(), messageText);
        if (StringUtils.isNotBlank((CharSequence)imageId)) {
            Message messageImg = new Message();
            MediaContent image = new MediaContent();
            image.setMedia_id(imageId);
            messageImg.setMsgtype("image");
            messageImg.setTouser(FromUserName);
            messageImg.setImage(image);
            this.crmSendMessageService.sendMessageOfImg(this.wechatService.getWeChatToken(), messageImg, null);
        }
    }

    public boolean checkToken(String signature, String timestamp, String nonce, boolean hasEncrypt) {
        String result = "";
        if (hasEncrypt) {
            try {
                result = SHA1.getSHA1((String)"b3c4992d4393421c9e7482f4b64d0422", (String)timestamp, (String)nonce, (String)"IsnH7uaez2qG5smOnRDhBUj5t4c9babShD0k68bnnrT");
            }
            catch (AesException e) {
                e.printStackTrace();
            }
        } else {
            try {
                result = SHA1.getSHA1((String)"b3c4992d4393421c9e7482f4b64d0422", (String)timestamp, (String)nonce);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result.equals(signature);
    }
}

