/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.dto.WxUserInfo;
import com.bxm.localnews.thirdparty.service.WxMpAuthService;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.base.Splitter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import me.chanjar.weixin.mp.bean.result.WxMpUserList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"3-10 \u5fae\u4fe1\u6388\u6743\u76f8\u5173\u63a5\u53e3"}, description="\u5fae\u4fe1\u6388\u6743\u76f8\u5173\u63a5\u53e3\u64cd\u4f5c")
@RefreshScope
@RestController
@RequestMapping(value={"api/public/auth"})
public class WxMpAuthController {
    private WxMpService wxMpService;
    private WxMpAuthService wxMpAuthService;
    private BizConfigProperties bizConfigProperties;

    @Autowired
    public WxMpAuthController(WxMpAuthService wxMpAuthService, WxMpService wxMpService, BizConfigProperties bizConfigProperties) {
        this.wxMpAuthService = wxMpAuthService;
        this.wxMpService = wxMpService;
        this.bizConfigProperties = bizConfigProperties;
    }

    @ApiOperation(value="3-10-2 \u751f\u6210\u91cd\u5b9a\u5411\u5730\u5740", notes="\u8fd4\u56de\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"/authorize"})
    public Json<String> authorize(@RequestParam(value="returnUrl") String returnUrl) {
        String url = this.bizConfigProperties.getServerHost() + "/api/public/auth/userInfo";
        String redirectUrl = this.wxMpService.oauth2buildAuthorizationUrl(returnUrl, "snsapi_userinfo", "STAT");
        String str = StringUtils.substringAfterLast((String)redirectUrl, (String)"?");
        Map map = Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)str);
        String code = (String)map.get("code");
        return ResultUtil.genSuccessResult((Object)code);
    }

    @ApiOperation(value="3-10-1 \u6839\u636ecode\u83b7\u53d6\u7528\u6237\u4fe1\u606f", notes="\u8fd4\u56de\u7ed3\u679c\uff1aresult.userId == null\u5219\u9700\u8981\u8fdb\u884c\u6ce8\u518c\u6216\u8005\u7ed1\u5b9a")
    @GetMapping(value={"/userInfo"})
    public Json<WxUserInfo> userInfo(@RequestParam(value="code") String code) {
        return ResultUtil.genSuccessResult((Object)this.wxMpAuthService.getUserByCode(code));
    }

    @ApiOperation(value="\u6839\u636eopenId\u83b7\u53d6\u7528\u6237\u5217\u8868", notes="", hidden=true)
    @GetMapping(value={"/userList"})
    public Json<WxMpUserList> userList(String nextOpenId) {
        return ResultUtil.genSuccessResult((Object)this.wxMpAuthService.getUserList(nextOpenId));
    }

    @ApiOperation(value="\u6839\u636eopenId\u83b7\u53d6\u7528\u6237\u4fe1\u606f", notes="", hidden=true)
    @GetMapping(value={"/{opendId}"})
    public Json<WxMpUser> userInfoByOpenId(@PathVariable String opendId) {
        return ResultUtil.genSuccessResult((Object)this.wxMpAuthService.getUser(opendId));
    }

    @ApiOperation(value="\u83b7\u53d6js\u7b7e\u540d\u9a8c\u8bc1", notes="")
    @GetMapping(value={"/jssignature"})
    public Json<WxJsapiSignature> getWxJsapiSignature(@RequestParam(value="url") String url) {
        return ResultUtil.genSuccessResult((Object)this.wxMpAuthService.getWxJsapiSignature(url));
    }
}

