/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserAuthIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.param.UserParam;
import com.bxm.localnews.thirdparty.config.WechatProperties;
import com.bxm.localnews.thirdparty.constant.InviteTypeEnum;
import com.bxm.localnews.thirdparty.dto.WechatDto;
import com.bxm.localnews.thirdparty.dto.WxUserInfo;
import com.bxm.localnews.thirdparty.service.WechatService;
import com.bxm.localnews.vo.UserAuth;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.Message;
import com.qq.weixin.mp.aes.AES;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import me.chanjar.weixin.common.util.crypto.PKCS7Encoder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatServiceImpl
implements WechatService {
    private static final Logger logger = LoggerFactory.getLogger(WechatServiceImpl.class);
    private static final String WATERMARK = "watermark";
    private static final String APPID = "appid";
    private static final String WE_CHAT_URL = "https://api.weixin.qq.com/cgi-bin/token";
    private static final String GRANT_TYPE = "client_credential";
    private final String url = "https://api.weixin.qq.com/sns/jscode2session?appid={appid}&secret={secret}&js_code={js_code}&grant_type=authorization_code";
    private final String qrUrl = "https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token={}";
    private RedisStringAdapter redisStringAdapter;
    private WechatProperties wechatProperties;
    private HttpClientService httpClientService;
    private AliyunOSSService aliyunOSSService;
    private UserIntegrationService userIntegrationService;
    private UserAuthIntegrationService userAuthIntegrationService;
    private JSONObject token_json;

    @Autowired
    public WechatServiceImpl(HttpClientService httpClientService, WechatProperties wechatProperties, AliyunOSSService aliyunOSSService, UserIntegrationService userIntegrationService, UserAuthIntegrationService userAuthIntegrationService, RedisStringAdapter redisStringAdapter) {
        this.httpClientService = httpClientService;
        this.wechatProperties = wechatProperties;
        this.aliyunOSSService = aliyunOSSService;
        this.userIntegrationService = userIntegrationService;
        this.userAuthIntegrationService = userAuthIntegrationService;
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public WxUserInfo getWechatInfo(WechatDto wechatDto) {
        WxUserInfo wxUserInfo = new WxUserInfo();
        String code = wechatDto.getCode();
        if (StringUtils.isNotEmpty((String)code)) {
            UserAuth userAuth;
            String requestUrl = "https://api.weixin.qq.com/sns/jscode2session?appid={appid}&secret={secret}&js_code={js_code}&grant_type=authorization_code".replace("{js_code}", code).replace("{appid}", this.wechatProperties.getAppId()).replace("{secret}", this.wechatProperties.getSecret());
            JSONObject jsonObject = JSON.parseObject((String)this.httpClientService.doGet(requestUrl));
            if (logger.isDebugEnabled()) {
                logger.debug("code \u83b7\u53d6openid \u7ed3\u679c\uff1a " + jsonObject.toJSONString());
            }
            String openId = jsonObject.getString("openid");
            wxUserInfo.setOpenId(openId);
            wxUserInfo.setSessionKey(jsonObject.getString("session_key"));
            wxUserInfo.setUnionId(jsonObject.getString("unionid"));
            if (null != openId && null != (userAuth = this.userAuthIntegrationService.selectAppletUserAuthByOpenId(openId))) {
                UserInfoDTO userInfo;
                wxUserInfo.setUserId(userAuth.getUserId());
                if (null != userAuth.getUserId() && (userInfo = this.userIntegrationService.getUserFromRedisDB(userAuth.getUserId())) != null) {
                    wxUserInfo.setNickname(userInfo.getNickname());
                    wxUserInfo.setHeadImg(userInfo.getHeadImg());
                }
            }
        }
        return wxUserInfo;
    }

    @Override
    public String getWechatQRCode(WechatDto wechatDto) {
        String weChatToken = this.getWeChatToken();
        if (logger.isDebugEnabled()) {
            logger.debug("wechat token : " + weChatToken);
        }
        String requestUrl = "https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token={}".replace("{}", weChatToken);
        JSONObject param = new JSONObject();
        param.put("scene", (Object)wechatDto.getScene());
        param.put("page", (Object)wechatDto.getPage());
        param.put("width", (Object)wechatDto.getWidth());
        param.put("auto_color", (Object)wechatDto.getAutoColor());
        JSONObject jsonLineColor = JSON.parseObject((String)wechatDto.getLineColor());
        Map innerMap = jsonLineColor.getInnerMap();
        param.put("line_color", (Object)innerMap);
        param.put("is_hyaline", (Object)wechatDto.getHyaline());
        String result = this.httpPost(requestUrl, param, wechatDto.getInviteUserId());
        return result;
    }

    @Override
    public String createUser(String encryptedData, String sessionKey, String iv, Long inviteUserId, String ip, String platform, String area) {
        try {
            AES aes = new AES();
            byte[] resultByte = aes.decrypt(Base64.decodeBase64((String)encryptedData), Base64.decodeBase64((String)sessionKey), Base64.decodeBase64((String)iv));
            if (null != resultByte && resultByte.length > 0) {
                String result = new String(PKCS7Encoder.decode((byte[])resultByte));
                JSONObject jsonObject = JSON.parseObject((String)result);
                String decryptAppid = jsonObject.getJSONObject(WATERMARK).getString(APPID);
                if (this.wechatProperties.getAppId().equals(decryptAppid)) {
                    UserParam userParam = new UserParam();
                    userParam.setOpenId(jsonObject.getString("openId"));
                    userParam.setUnionId(jsonObject.getString("unionId"));
                    userParam.setHeadImg(jsonObject.getString("avatarUrl"));
                    userParam.setNickName(jsonObject.getString("nickName"));
                    userParam.setSex(jsonObject.getByte("gender"));
                    userParam.setRegIp(ip);
                    userParam.setPlatform(platform);
                    userParam.setRegisteredAddress(area);
                    userParam.setInviteUserId(inviteUserId);
                    userParam.setInviteType(InviteTypeEnum.APPLETDRAW.name());
                    Message message = this.userIntegrationService.createUser(userParam);
                    if (message != null && message.isSuccess()) {
                        return ObjectUtils.toString(message.getParamMap().get("userId"));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u7528\u6237\u5931\u8d25\uff1a", (Throwable)e);
        }
        return "";
    }

    @Override
    public Boolean setUserFormId(Long userId, String formId) {
        KeyGenerator key = RedisConfig.WEIXIN_FORMID.copy().appendKey((Object)userId);
        this.redisStringAdapter.set(key, (Object)formId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String httpPost(String url, JSONObject jsonParam, Long inviteUserId) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/json");
        httpPost.setConfig(RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(10000).build());
        logger.info("getWechatQRCode url is:{},jsonParam is:{}", (Object)url, (Object)jsonParam);
        try {
            String path;
            String imgName = DateUtils.formatDate((Date)new Date()) + "/" + UUID.randomUUID() + "-" + inviteUserId + ".png";
            if (null != jsonParam) {
                StringEntity entity = new StringEntity(jsonParam.toString(), "utf-8");
                entity.setContentEncoding("UTF-8");
                entity.setContentType("image/png");
                httpPost.setEntity((HttpEntity)entity);
            }
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            InputStream inputStream = response.getEntity().getContent();
            String string = path = this.aliyunOSSService.upload(inputStream, "/qr/" + imgName);
            return string;
        }
        catch (IOException e) {
            logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url, (Throwable)e);
        }
        finally {
            httpPost.releaseConnection();
        }
        return null;
    }

    @Override
    public String getWeChatToken() {
        try {
            if (null != this.token_json && null != this.token_json.get((Object)"timestamp") && (int)((System.currentTimeMillis() - Long.parseLong(String.valueOf(this.token_json.get((Object)"timestamp")))) / 1000L) <= 1800) {
                if (null != this.token_json.get((Object)"access_token")) {
                    return this.token_json.get((Object)"access_token").toString();
                }
                logger.error("get access_token error! errorCode:{} ,errorMsg:{} ", this.token_json.get((Object)"errcode"), this.token_json.get((Object)"errmsg"));
            }
            StringBuffer url = new StringBuffer();
            url.append(WE_CHAT_URL).append("?");
            url.append("grant_type=").append(GRANT_TYPE);
            url.append("&").append("appid=").append(this.wechatProperties.getAppId());
            url.append("&").append("secret=").append(this.wechatProperties.getSecret());
            JSONObject jsonObject = JSON.parseObject((String)this.httpClientService.doGet(url.toString()));
            if (null != jsonObject) {
                if (null != jsonObject.get((Object)"access_token")) {
                    jsonObject.put("timestamp", (Object)System.currentTimeMillis());
                    this.token_json = jsonObject;
                    return String.valueOf(jsonObject.get((Object)"access_token"));
                }
                logger.info("get access_token from weChat error! errorCode:{} ,errorMsg:{} ", jsonObject.get((Object)"errcode"), jsonObject.get((Object)"errmsg"));
            }
        }
        catch (Exception e) {
            logger.error("getWeChatToken system error", (Throwable)e);
        }
        return null;
    }

    @Override
    public void emptyWeChatToken() {
        this.token_json = null;
    }
}

