package com.bxm.localnews.user.controller;


import com.bxm.localnews.common.annotation.TouTiaoAuth;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.service.UserHobbyService;
import com.bxm.localnews.user.vo.Hobby;
import com.bxm.localnews.user.vo.UserHobby;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "9-04 用户爱好接口", description = "对用户兴趣爱好的操作")
@RequestMapping("api/user/hobby")
@RestController
public class HobbyController {

    @Autowired
    UserHobbyService userHobbyService;

    @ApiOperation(value = "9-04-01 修改或添加用户兴趣", notes = "修改用户兴趣", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "hobbyNames", value = "兴趣名称", required = true)
    })
    @TouTiaoAuth
    @PostMapping()
    public Json resort(Long userId, String[] hobbyNames) {
        userHobbyService.saveUserHooby(userId,hobbyNames);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value = "9-04-02 所有兴趣爱好", notes = "列举所有兴趣爱好", httpMethod = "GET")
    @GetMapping("/list/all")
    public Json<List<Hobby>> listHobby() {
        return ResultUtil.genSuccessResult(userHobbyService.listHobby());
    }


    @ApiOperation(value = "9-04-03 用户兴趣爱好", notes = "列举用户兴趣爱好", httpMethod = "GET")
    @GetMapping("/list")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
    })
    public Json<List<UserHobby>> listUserHobby(@RequestParam Long userId) {

        return ResultUtil.genSuccessResult(userHobbyService.listUserHobby(userId));
    }
}
