package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.service.LoginService;
import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.LoginMeta;
import com.bxm.newidea.component.util.WebUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@Api(tags = "9-01 用户登录", description = "用户登录和注册")
@RestController
@RequestMapping("api/login")
public class LoginController {

    @Resource
    private LoginService loginService;

    @ApiOperation(value = "9-01-1 用户登录、密码重置并登陆", notes = "支持账号（手机号码）密码登录、第三方登录、验证码登录")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "platform", value = "平台信息"),
            @ApiImplicitParam(name = "chnl", value = "渠道信息,当前APP的平台")
    })
    @RequestMapping(value = "toLogin", method = {RequestMethod.GET, RequestMethod.POST})
    public Json<LoginMeta> login(LoginInfo loginInfo, Integer platform, String chnl, HttpServletRequest request) {
        String ip = WebUtils.getIpAddr(request);
        loginInfo.setRegIp(ip);
        loginInfo.setLastLoginIp(ip);
        return this.loginService.doLogin(loginInfo, platform, chnl);
    }

    @ApiOperation(value = "9-01-2 用户注册", notes = "用户第三方信息注册并绑定手机号码，也可进行密码注册")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "platform", value = "平台信息"),
            @ApiImplicitParam(name = "chnl", value = "渠道信息,当前APP的平台，用于统计用户下载app的来源")
    })
    @RequestMapping(value = "registerBindingPhone", method = RequestMethod.POST)
    public Json<LoginMeta> registerAndBindingPhone(LoginInfo loginInfo, Integer platform, String chnl, HttpServletRequest request) {
        String ip = WebUtils.getIpAddr(request);
        loginInfo.setRegIp(ip);
        loginInfo.setLastLoginIp(ip);
        return this.loginService.registerAndBindingPhone(loginInfo, platform, chnl);
    }

}
