package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.annotation.TouTiaoAuth;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.param.StoreNeceParam;
import com.bxm.localnews.user.service.UserAmountService;
import com.bxm.localnews.user.vo.AmountRankingList;
import com.bxm.localnews.user.vo.UserAmount;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by mars on 2018/3/6.
 */
@Api(tags = "9-03 用户账户相关接口", description = "用户账户金额信息、收入排行等")
@RestController
@RequestMapping("api/amount")
public class UserAmountController {

    @Resource
    private UserAmountService userAmountService;

    @ApiOperation("9-03-1 查询本周排行榜，总收入排行榜")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID"),
            @ApiImplicitParam(name = "type", value = "查询类型1-本周排行；2-总排行榜")
    })
    @PostMapping(value = "incomeRankingList")
    @TouTiaoAuth
    public Json<List<AmountRankingList>> incomeRankingList(@RequestParam(value = "userId") Long userId,
                                                           @RequestParam(value = "type") Byte type) {
        return ResultUtil.genSuccessResult(this.userAmountService.selectAmountRankingList(userId, type));
    }

    @ApiOperation("9-03-2 用户账户信息")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @RequestMapping(value = "amountInfo", method = RequestMethod.POST)
    @TouTiaoAuth
    public Json<UserAmount> amountInfo(@RequestParam(value = "userId") Long userId) {
        return ResultUtil.genSuccessResult(this.userAmountService.findAmountByUserId(userId));
    }

}
