package com.bxm.localnews.user.controller;

import com.alibaba.fastjson.JSONArray;
import com.bxm.localnews.activity.service.InviteRelationService;
import com.bxm.localnews.activity.service.NoviceTaskRecordService;
import com.bxm.localnews.base.dto.LocationDTO;
import com.bxm.localnews.common.annotation.TouTiaoAuth;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.message.constant.SmsTemplateEnum;
import com.bxm.localnews.message.dto.SmsJson;
import com.bxm.localnews.message.service.SmsSupplyService;
import com.bxm.localnews.user.dto.PayToken;
import com.bxm.localnews.user.dto.RegisterMeta;
import com.bxm.localnews.user.dto.UserBaseInfoDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.param.UserParam;
import com.bxm.localnews.user.service.UserBaseInfoService;
import com.bxm.localnews.user.service.UserInternalService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.LoginMeta;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserAddressBook;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.tools.Validater;
import com.bxm.newidea.component.util.WebUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

@Api(tags = "9-02 用户注册", description = "用户注册和管理")
@RestController
@RequestMapping("api/user")
@RefreshScope
public class UserController extends BaseController {

    @Resource
    private UserService userService;

    @Resource
    private RedisStringAdapter redisStringAdapter;

    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Resource
    private SmsSupplyService smsSupplyService;

    @Resource
    private BizConfigProperties bizConfigProperties;

    @Resource
    private NoviceTaskRecordService noviceTaskRecordService;

    @Resource
    private InviteRelationService inviteRelationService;

    @Resource
    private UserBaseInfoService userBaseInfoService;

    @Resource
    private UserInternalService userInternalService;

    @ApiOperation(value = "9-02-1 静默注册", notes = "用户打开app，不存在userId,根据设备号来返回该手机游客模式的userId")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "platform", value = "平台信息"),
            @ApiImplicitParam(name = "chnl", value = "渠道信息,当前APP的平台"),
            @ApiImplicitParam(name = "firstOpenType", value = "是否是第一次打开应用，1：首次打开"),
    })
    @RequestMapping(value = "toRegister", method = RequestMethod.POST)
    public Json<LoginMeta> register(LoginInfo loginInfo, Integer platform, String chnl, String firstOpenType,HttpServletRequest request) {
        loginInfo.setRegIp(WebUtils.getIpAddr(request));
        return this.userService.register(loginInfo, platform, chnl, firstOpenType);
    }

    @ApiOperation(value = "9-02-2 h5页面注册", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "platform", value = "平台信息", allowableValues = "1,2", required = true),
            @ApiImplicitParam(name = "chnl", value = "渠道信息")
    })
    @RequestMapping(value = "/H5/toRegister", method = RequestMethod.POST)
    public Json<User> h5Register(LoginInfo loginInfo, Integer platform, String chnl,HttpServletRequest request) {
        loginInfo.setRegIp(WebUtils.getIpAddr(request));
        return this.userService.doH5Register(loginInfo, platform, chnl);
    }

    @ApiOperation(value = "9-02-3 重置用户token", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id"),
            @ApiImplicitParam(name = "refreshToken", value = "刷新的token")
    })
    @RequestMapping(value = "refreshToken", method = RequestMethod.POST)
    public Json<UserInfoDTO> refreshToken(@RequestParam(value = "userId") long userId,
                                          @RequestParam(value = "refreshToken") String refreshToken) {
        return this.userService.refreshToken(userId, refreshToken);
    }

    @ApiOperation(value = "9-02-4 获取绑定手机号码的验证码", notes = "")
    @ApiImplicitParam(name = "phone", value = "手机号")
    @PostMapping("getBindPhoneCode")
    public SmsJson getVerificationCode(String phone, HttpServletRequest httpServletRequest) {
        if (!Validater.checkPhone(phone)) {
            return SmsJson.build(ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "手机号码格式错误"));
        }
        return this.smsSupplyService.sendSmsByVCodeTemplate(phone, SmsTemplateEnum.BINDING_PHONE,
                WebUtils.getIpAddr(httpServletRequest));
    }

    @ApiOperation(value = "9-02-5 退出登录", notes = "")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @GetMapping(value = "logout")
    @TouTiaoAuth
    public Json logout(Long userId) {
        // 清空用户redis信息
        this.redisHashMapAdapter.remove(RedisConfig.USER_INFO, userId.toString());
        // 将token 设置过期
        this.userService.updateUserTokenExpireTime(userId);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value = "9-02-6 绑定三方账号", notes = "")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @RequestMapping(value = "bindingAccount", method = RequestMethod.POST)
    @TouTiaoAuth
    public Json<UserInfoDTO> binding(LoginInfo loginInfo, Long userId) {
        return this.userService.binding(loginInfo, userId);
    }

    @ApiOperation(value = "9-02-7 [任务]开启推送通知", notes = "")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @PostMapping(value = "openingNotice")
    @TouTiaoAuth
    public Json openingNotice(@RequestParam(value = "userId") long userId) {
        return this.noviceTaskRecordService.openingNotice(userId);
    }

    @ApiOperation(value = "9-02-8 [任务]拜师", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID"),
            @ApiImplicitParam(name = "masterId", value = "邀请码（师傅用户ID）")
    })
    @RequestMapping(value = "apprentice", method = {RequestMethod.GET, RequestMethod.POST})
    public Json apprentice(@RequestParam(value = "userId") long userId,
                           @RequestParam(value = "masterId") long masterId) {
        return this.inviteRelationService.apprentice(userId, masterId);
    }

    @ApiOperation(value = "9-02-9 [任务]匹配通讯录", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID"),
            @ApiImplicitParam(name = "addressBookJson", value = "通讯录")
    })
    @PostMapping(value = "getAddressBook")
    @TouTiaoAuth
    public Object getAddressBook(@RequestParam(value = "userId") long userId,
                                 @RequestParam(value = "addressBookJson") String addressBookJson) {
        if (StringUtils.isEmpty(addressBookJson)) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "参数不能为空");
        }
        List<UserAddressBook> addressBookList = JSONArray.parseArray(addressBookJson, UserAddressBook.class);
        return this.noviceTaskRecordService.getAddressBook(userId, addressBookList);
    }

    @ApiOperation(value = "9-02-10 获取用户基本信息", notes = "包含 头像、昵称、性别、生日、地址、兴趣")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @RequestMapping(value = "getUserBaseInfo", method = RequestMethod.GET)
    @TouTiaoAuth
    public Json<UserInfoDTO> getUserBaseInfo(@RequestParam(value = "userId") long userId) {
        return ResultUtil.genSuccessResult(this.userService.getUserFromRedisDB(userId));
    }

    @ApiOperation(value = "9-02-11 更新用户信息", notes = "目前支持 性别、生日、地址")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @RequestMapping(value = "updateUserInfo", method = RequestMethod.POST)
    @TouTiaoAuth
    public Json getUserBaseInfo(UserParam user, Long userId, @RequestParam("file") MultipartFile file)  {
        return this.userService.updateUserInfo(user, userId,file);
    }

    @ApiOperation(value = "9-02-12 获取用户支付token", notes = "获取用户的支付token，有效期为一个小时")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @PostMapping(value = "getPayToken")
    @TouTiaoAuth
    public Json<PayToken> getPayToken(Long userId) {
        String token = this.userService.getToken();
        String cacheKey = userId + token;
        return ResultUtil.genSuccessResult(new PayToken(token));
    }

    @ApiOperation(value = "9-02-12 获取用户推广链接（包含用户邀请码）")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @RequestMapping(value = "getRegisterUrl", method = RequestMethod.POST)
    @TouTiaoAuth
    public Json<RegisterMeta> getRegisterUrl(Long userId) {
        String channelUrl = bizConfigProperties.getChannelUrl();
        return ResultUtil.genSuccessResult(new RegisterMeta(channelUrl + userId));
    }

    @ApiOperation(value = "9-02-13 获取个人相关信息",notes = "包含姓名、头像、金币、签到信息、邀请人数")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "platform", value = "平台，1：安卓，2：IOS", allowableValues = "1,2", required = true),
    })
    @GetMapping(value = "getUserInfo")
    @TouTiaoAuth
    public Json<UserBaseInfoDTO> getUserInfo(@RequestParam(value = "userId") long userId,
                                             @RequestParam(value = "platform") int platform) {
        return ResultUtil.genSuccessResult(this.userBaseInfoService.getUserInfoForWST(userId,platform));
    }

    @ApiOperation(value = "9-02-14 定位得到城市并更新位置",notes = "根据客户端传过来的区域编号更新用户的地理位置，并添加用户地理位置历史")
    @PostMapping(value = "/location")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID"),
            @ApiImplicitParam(name = "code", value = "地区编码")
    })
    public Json<LocationDTO> getUserLocation(@RequestParam(value = "userId") long userId,
                                             @RequestParam(value = "code") String code) {
        return ResultUtil.genSuccessResult(userInternalService.postingLocation(code,userId));
    }



}
