package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.account.CashFlowService;
import com.bxm.localnews.user.account.UserAmountService;
import com.bxm.localnews.user.dto.AccountCashFlowDTO;
import com.bxm.localnews.user.dto.AccountIncomeDTO;
import com.bxm.localnews.user.dto.CashFlowDTO;
import com.bxm.localnews.user.param.AccountCashFlowPageParam;
import com.bxm.localnews.user.param.CashFlowParam;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "9-07 用户现金流水相关API", description = "用户现金流水相关信息")
@RestController
public class CashFlowController {

    private final CashFlowService cashFlowService;

    private final UserAmountService userAmountService;

    @Autowired
    public CashFlowController(CashFlowService cashFlowService, UserAmountService userAmountService) {
        this.cashFlowService = cashFlowService;
        this.userAmountService = userAmountService;
    }

    @ApiOperation(value = "9-07-1 获取用户流水信息", notes = "用户的流水列表")
    @GetMapping("api/user/cash/flow")
    public Json<List<CashFlowDTO>> getUserCashFlow(CashFlowParam cashFlowParam) {
        return ResultUtil.genSuccessResult(this.cashFlowService.getUserAllCashFlow(cashFlowParam));
    }

    @ApiOperation(value = "9-07-3 [v1]分页获取现金收益流水", notes = "分页查询用户现金收益流水")
    @GetMapping("{version}/user/account/cash/flow")
    @ApiVersion(1)
    public ResponseJson<PageWarper<AccountCashFlowDTO>> getUserCashFlow(AccountCashFlowPageParam param) {
        return ResponseJson.ok(cashFlowService.queryCashByPage(param));
    }

    @ApiOperation(value = "9-07-4 [v1]获取用户现金收益数据", notes = "用户用户相关的现金收益与配置的流水分类列表")
    @GetMapping("{version}/user/account/cash/income")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @ApiVersion(1)
    public ResponseJson<AccountIncomeDTO> getIncome(Long userId) {
        return ResponseJson.ok(userAmountService.getCashIncome(userId));
    }
}
