package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.dto.CustomerHomePageDTO;
import com.bxm.localnews.user.dto.OnselfHomePageDTO;
import com.bxm.localnews.user.support.HomePageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "9-10 用户个人主页相关API", description = "用户个人主页相关信息")
@RestController
@RequestMapping("api/user/homePage")
@AllArgsConstructor(onConstructor = @__(@Autowired))
public class HomePageController {

    private final HomePageService homePageService;

    @ApiOperation(value = "9-10-01 主态用户访问主页", notes = "主态用户访问主页", httpMethod = "GET")
    @GetMapping("/oneself")
    @ApiImplicitParams({
        @ApiImplicitParam(name = "userId", value = "用户id", required = true),
    })
    public Json<OnselfHomePageDTO> getHomePageByUserId(@RequestParam Long userId) {
        return ResultUtil.genSuccessResult(homePageService.getOnselfHomePage(userId));
    }

    @ApiOperation(value = "9-10-02 客态用户访问主页", notes = "客态用户访问主页", httpMethod = "GET")
    @GetMapping("/customer")
    @ApiImplicitParams({
        @ApiImplicitParam(name = "userId", value = "用户id", required = true),
        @ApiImplicitParam(name = "targetUserId", value = "访问用户id", required = true),
    })
    public Json<CustomerHomePageDTO> getHomePageByCustomer(Long userId, Long targetUserId) {
        return ResultUtil.genSuccessResult(homePageService.getCustomerHomePage(targetUserId, userId));
    }

}
