package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.dto.NativeDTO;
import com.bxm.localnews.user.param.NativeParam;
import com.bxm.localnews.user.support.NativeUserService;
import com.bxm.newidea.component.annotations.ApiVersion;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 本地人推荐控制器
 */
@Api(tags = "9-14 本地人推荐相关API")
@RestController
@RequestMapping("{version}/user/native")
public class NativeRecommendUserController {

    @Autowired
    private NativeUserService nativeUserService;

    @ApiOperation(value = "9-14-03 [v3]本地人推荐", notes = "按条件筛选本地人", httpMethod = "GET")
    @GetMapping("/list/{userId}")
    @ApiVersion(3)
    public Json<NativeDTO> listNativeUserForV3(@PathVariable Long userId, @Valid NativeParam nativeParam, BasicParam basicParam) {
        return ResultUtil.genSuccessResult(nativeUserService.listNativeForV3(userId, nativeParam, basicParam));
    }

    @ApiOperation(value = "9-14-02 [v2]本地人推荐", notes = "按条件筛选本地人", httpMethod = "GET")
    @GetMapping("/list/{userId}")
    @ApiVersion(2)
    public Json<NativeDTO> listNativeUserForV2(@PathVariable Long userId, @Valid NativeParam nativeParam, BasicParam basicParam) {
        return ResultUtil.genSuccessResult(nativeUserService.listNativeForV2(userId, nativeParam, basicParam));
    }

    @ApiOperation(value = "9-14-01 [v1]本地人推荐", notes = "按条件筛选本地人", httpMethod = "GET")
    @GetMapping("/list/{userId}")
    @ApiVersion(1)
    public Json<NativeDTO> listNativeUserForV1(@PathVariable Long userId, @Valid NativeParam nativeParam, BasicParam basicParam) {
        return ResultUtil.genSuccessResult(nativeUserService.listNative(userId, nativeParam, basicParam));
    }

}
