package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.attribute.RedPacketService;
import com.bxm.localnews.user.dto.UserRedPacketDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhaoyadong 2019/3/4 19:00
 * @desc
 */
@Api(tags = "9-09 用户红包相关API", description = "领取红包相关操作")
@RestController
@RequestMapping("api/red/packet")
public class RedPackController {

    @Resource
    private RedPacketService redPacketService;

    @ApiOperation(value = "9-09-1 用户领取红包", notes = "用户领取红包")
    @ApiImplicitParams({
        @ApiImplicitParam(name = "userId", value = "用户id"),
        @ApiImplicitParam(name = "areaCode", value = "地区编码(12位地区编码)")
    })
    @PostMapping("")
    public Json<BigDecimal> userReceiveRedPacket(BasicParam basicParam, @RequestParam("userId") Long userId,
        @RequestParam("areaCode") String areaCode) {
        return this.redPacketService.userReceiveRedPacket(userId, basicParam, areaCode);
    }

    @ApiOperation(value = "9-09-2 获取对应地区是否开启红包", notes = "判断用户是否满足领取新人红包条件")
    @ApiImplicitParams({
        @ApiImplicitParam(name = "userId", value = "用户id"),
        @ApiImplicitParam(name = "areaCode", value = "地区编码(12位地区编码)")
    })
    @GetMapping("/enable")
    public Json<UserRedPacketDTO> enableRedPacket(BasicParam basicParam, @RequestParam("userId") Long userId,
        @RequestParam("areaCode") String areaCode) {
        //由于安卓红包弹窗bug，需热修复成安卓调用接口返回失败
        if (1 == basicParam.getPlatform()) {
            return ResultUtil.genFailedResult("");
        }

        return ResultUtil.genSuccessResult(this.redPacketService.enableRedPacket(basicParam.getDevcId(), userId, areaCode));
    }
}
