package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.account.AccountService;
import com.bxm.localnews.user.account.UserAccountService;
import com.bxm.localnews.user.dto.UserAccountDTO;
import com.bxm.localnews.user.dto.UserAccountDayCashDTO;
import com.bxm.localnews.user.dto.UserCashGoldDTO;
import com.bxm.localnews.user.param.TransformParam;
import com.bxm.localnews.user.vo.UserCashInfoVo;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;

/**
 * @author zhaoyadong 2019/3/4 13:58
 * @desc
 */
@Api(tags = "9-06 用户账户相关API", description = "用户账户金额信息、金币信息、明细等")
@RestController
public class UserAccountController {

    @Resource
    private UserAccountService userAccountService;

    @Resource
    private AccountService accountService;

    @ApiOperation(value = "9-06-1 获取我的账户信息", httpMethod = "GET", notes = "获取用户对应的金币余额和现金余额、金币总收入、现金总收入")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id")
    })
    @GetMapping("/api/user/account")
    public ResponseJson<UserAccountDTO> getUserAccount(@RequestParam("userId") Long userId) {
        return ResponseJson.ok(this.userAccountService.getUserAccountAndEnableWithdraw(userId));
    }

    @ApiOperation(value = "9-06-2 获取用户账户信息和最近7天的现金收入", httpMethod = "GET", notes = "用户账户信息和统计用户对应每天的收入信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id"),
            @ApiImplicitParam(name = "areaCode", value = "区域Code"),
    })
    @GetMapping("/api/user/account/cash")
    public Json<UserAccountDayCashDTO> getUserCashByDay(@RequestParam("userId") Long userId,
                                                        @RequestParam("areaCode") String areaCode) {

        return ResultUtil.genSuccessResult(this.userAccountService.getUserAccountAndDetail(userId, areaCode));
    }

    @ApiOperation(value = "9-06-3 获取个人中心钱包和金币信息", httpMethod = "GET", notes = "获取用户对应的金币余额和现金余额")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id")
    })
    @GetMapping("/api/user/account/my")
    public Json<UserCashGoldDTO> getUserCashGold(@RequestParam("userId") Long userId) {
        return ResultUtil.genSuccessResult(this.userAccountService.getUserCashGold(userId));
    }

    @ApiOperation(value = "9-06-4 用户提现弹窗上报", httpMethod = "POST", notes = "用户已经出现弹窗需要上报给服务端")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id")
    })
    @PostMapping("/api/user/account/pop/withdraw")
    public Json userWithdrawPop(@RequestParam("userId") Long userId) {
        userAccountService.userWithdrawPop(userId);
        return ResultUtil.genSuccessMsg();
    }

    @ApiOperation(value = "9-06-5 用户账户积分兑换", httpMethod = "POST", notes = "用户账户可用积分提现到微信;" +
            "返回值：大于0则提现成功")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id"),
            @ApiImplicitParam(name = "openId", value = "用户openId"),
            @ApiImplicitParam(name = "amount", value = "提现金额")
    })
    @PostMapping("/api/user/account/gold/withdraw")
    public Json userGoldWithdraw(@RequestParam("userId") Long userId, @RequestParam("openId") String openId,
                                 @RequestParam("amount") BigDecimal amount,
                                 BasicParam basicParam, HttpServletRequest request) {
        return userAccountService.userGoldWithdraw(userId, openId, amount, basicParam.getDevcId(),
                WebUtils.getIpAddr(request));
    }

    @ApiOperation(value = "9-06-6 获取用户及邀请人已获得金额信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true)
    })
    @GetMapping("/api/user/account/public/getUserCashInfo")
    public Json<UserCashInfoVo> getUserCashInfo(@RequestParam(name = "userId") Long userId) {
        return ResultUtil.genSuccessResult(userAccountService.getUserCashInfo(userId));
    }

    @ApiOperation(value = "9-06-7 [v1] 获取用户小红花信息", notes = "获取用户小红花信息", httpMethod = "GET")
    @ApiImplicitParam(name = "userId", value = "用户id")
    @GetMapping("{version}/user/account/balance")
    @ApiVersion(1)
    public Json<BigDecimal> selectUsableGoldByUserId(@RequestParam("userId") Long userId) {
        return ResultUtil.genSuccessResult(accountService.selectUsableGoldByUserId(userId));
    }

    @ApiOperation(value = "9-06-8 [v1] 用户赠送小红包给目标聊天用户")
    @PostMapping("{version}/user/account/transform")
    @ApiVersion(1)
    public Json<BigDecimal> presentFlower(@RequestBody TransformParam param) {
        return ResultUtil.genSuccessResult(userAccountService.presentFlower(param));
    }
}
