package com.bxm.localnews.user.controller;

import com.bxm.localnews.user.attribute.UserChannelService;
import com.bxm.localnews.user.dto.UserAllChannelDTO;
import com.bxm.localnews.user.dto.UserChannelDTO;
import com.bxm.localnews.user.param.UserChannelParam;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "9-22 用户栏目管理", description = "用户栏目管理")
@RestController
@RequestMapping("{version}/user/channel")
public class UserChannelController {

    @Autowired
    private UserChannelService userChannelService;

    @ApiOperation(value = "9-22-01 [v1]根据定位和用户获取栏目列表", notes = "根据定位和用户获取栏目列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId" ,value ="用户id" ,required = true,paramType = "long"),
            @ApiImplicitParam(name = "locationCode" ,value ="地区编码" ,required = true,paramType = "String")
    })
    @GetMapping("/location/getUserChannel")
    @ApiVersion(1)
    public ResponseJson<List<UserChannelDTO>> getUserChannel(UserChannelParam userChannelParam) {
        return ResponseJson.ok(userChannelService.getUserChannel(userChannelParam));
    }

    @ApiOperation(value = "9-22-02 [v1]根据定位获取用户的已选栏目和未选栏目", notes = "根据定位获取用户的已选栏目和未选栏目")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId" ,value ="用户id" ,required = true,paramType = "long"),
            @ApiImplicitParam(name = "locationCode" ,value ="地区编码" ,required = true,paramType = "String")
    })
    @GetMapping("/location/getAllUserChannel")
    @ApiVersion(1)
    public ResponseJson<UserAllChannelDTO> getAllUserChannel(UserChannelParam userChannelParam) {
        return ResponseJson.ok(userChannelService.getAllUserChannel(userChannelParam));
    }


    @ApiOperation(value = "9-22-03 [v1]保存用户栏目信息", notes = "编辑修改个人栏目信息")
    @PostMapping("/location/updateUserChannel")
    @ApiVersion(1)
    public ResponseJson<Boolean> updateUserChannel(@RequestBody UserChannelParam userChannelParam) {
        return ResponseJson.ok(userChannelService.updateUserChannel(userChannelParam));
    }
}
