package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.attribute.UserFollowService;
import com.bxm.localnews.user.param.RecommendFollowUsersParam;
import com.bxm.localnews.user.param.UserFollowParam;
import com.bxm.localnews.user.vo.RecommendFollowUsersVo;
import com.bxm.localnews.user.vo.UserFollow;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.BasicParam;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;

@Api(tags = "9-11 用户关注相关API", description = "用户关注和粉丝")
@RestController
@RequestMapping("api/user/follow")
public class UserFollowController extends BaseController {

    @Resource
    private UserFollowService userFollowService;

    @ApiOperation(value = "9-11-1 判断是否关注")
    @ApiImplicitParams({
        @ApiImplicitParam(name = "currentUserId", value = "当前用户ID"),
        @ApiImplicitParam(name = "targetUserId", value = "目标用户ID")
    })
    @GetMapping(value = "isFollowed")
    public Json<Boolean> isFollowed(@RequestParam(name = "currentUserId") Long currentUserId,
        @RequestParam(name = "targetUserId") Long targetUserId) {
        return ResultUtil.genSuccessResult(userFollowService.isFollowed(currentUserId, targetUserId));
    }

    @ApiOperation(value = "9-11-2 点击关注/取消关注")
    @ApiImplicitParams({
        @ApiImplicitParam(name = "userId", value = "用户ID"),
        @ApiImplicitParam(name = "followUserId", value = "关注用户ID"),
        @ApiImplicitParam(name = "type", value = "类型：0关注 1取消关注")
    })
    @PostMapping(value = "follow")
    public Json<Boolean> follow(@RequestParam(name = "userId") Long userId,
        @RequestParam(name = "followUserId") Long followUserId,
        @RequestParam(name = "type") Byte type) {
        return ResultUtil.genSuccessResult(userFollowService.follow(userId, followUserId, type));
    }

    @ApiOperation(value = "9-11-3 可能感兴趣的人")
    @ApiImplicitParams({
        @ApiImplicitParam(name = "userId", value = "用户ID"),
        @ApiImplicitParam(name = "areaCode", value = "地区编码(12位地区编码)")
    })
    @GetMapping(value = "mayInterested")
    public Json<List<UserFollow>> mayInterested(@RequestParam(name = "userId") Long userId,
        @RequestParam("areaCode") String areaCode) {
        return ResultUtil.genSuccessResult(userFollowService.mayInterested(userId, areaCode));
    }

    @ApiOperation(value = "9-11-4 关注列表")
    @GetMapping(value = "followList")
    public Json<PageWarper<UserFollow>> followList(UserFollowParam param) {
        return ResultUtil.genSuccessResult(userFollowService.followList(param));
    }

    @ApiOperation(value = "9-11-5 粉丝列表")
    @GetMapping(value = "followerList")
    public Json<PageWarper<UserFollow>> followerList(UserFollowParam param) {
        return ResultUtil.genSuccessResult(userFollowService.queryFunsByPage(param));
    }

    @ApiOperation(value = "9-11-6 虚拟用户批量关注，运营特供，请勿调用")
    @ApiImplicitParams({
        @ApiImplicitParam(name = "userId", value = "用户ID"),
        @ApiImplicitParam(name = "num", value = "数量")
    })
    @PostMapping(value = "public/virtualFollow")
    public Json virtualFollow(@RequestParam(name = "userId") Long userId,
        @RequestParam(name = "num") Integer num) {
        userFollowService.virtualFollow(userId, num);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value = "9-11-7 推荐关注用户列表",httpMethod = "GET",nickname = "pf.w")
    @GetMapping(value = "recommendFollowUsers")
    public ResponseJson<PageWarper<RecommendFollowUsersVo>> recommendFollowUsers(@Valid  RecommendFollowUsersParam param, BasicParam basicParam){
        return ResponseJson.ok(userFollowService.getRecommendFollowUsers(param));
    }
}
