package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.param.UserInformParam;
import com.bxm.localnews.user.support.UserInformService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "9-13 用户举报相关API", description = "用户举报相关信息")
@RestController
@RequestMapping("api/user/inform")
@AllArgsConstructor(onConstructor = @__(@Autowired))
public class UserInformController {

    private final UserInformService userInformService;

    @ApiOperation(value = "9-13-01 用户举报接口", notes = "客态用户访问主页", httpMethod = "POST")
    @PostMapping("submitInform")
    public Json<Boolean> submitUserInform(UserInformParam userInformParam) {
        return ResultUtil.genSuccessResult(userInformService.userInformService(userInformParam));

    }


}
