package com.bxm.localnews.user.controller;

import com.bxm.localnews.user.dto.UserInviteCollectDTO;
import com.bxm.localnews.user.dto.UserInviteDTO;
import com.bxm.localnews.user.invite.UserInviteService;
import com.bxm.localnews.user.model.dto.InviteCounterDTO;
import com.bxm.localnews.user.model.param.UserInviteConterParam;
import com.bxm.localnews.user.param.UserInvitePageParam;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "9-19 用户邀请人相关接口")
@RestController
@RequestMapping("{version}/user/invite")
public class UserInviteController {

    private final UserInviteService userInviteService;

    @Autowired
    public UserInviteController(UserInviteService userInviteService) {
        this.userInviteService = userInviteService;
    }

    @ApiOperation(value = "9-19-2 [v1]获取收徒统计信息",
            notes = "在我的徒弟页面显示收徒统计信息，包含统计数据和第一页徒弟数据")
    @ApiImplicitParam(name = "userId", value = "当前用户ID", required = true)
    @ApiVersion(1)
    @GetMapping("collect")
    public ResponseJson<UserInviteCollectDTO> getInviteCollect(@RequestParam Long userId) {
        return ResponseJson.ok(userInviteService.getInviteCollect(userId));
    }

    @ApiOperation(value = "9-19-3 [v1]分页获取徒弟列表")
    @ApiVersion(1)
    @GetMapping("page")
    public ResponseJson<PageWarper<UserInviteDTO>> getInviteByPage(UserInvitePageParam param) {
        return ResponseJson.ok(userInviteService.getInviteByPage(param));
    }

    @ApiOperation(value = "9-19-4 [v1]获取收徒统计信息", notes = "收徒总数、排行榜、滚动弹幕信息的综合")
    @ApiVersion(1)
    @GetMapping("public/counter")
    public ResponseJson<InviteCounterDTO> getInviteCounter(UserInviteConterParam param) {
        return ResponseJson.ok(userInviteService.getInviteCounter(param));
    }
}
