package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.attribute.UserPersonalInfoService;
import com.bxm.localnews.user.dto.UserAccountMaterialGuideDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.UserPersonalInfoDTO;
import com.bxm.localnews.user.param.*;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;

@Api(tags = "9-15 用户个人资料相关API")
@RestController
@RequestMapping("{version}/user/personal-info")
public class UserPersonalInfoController {

    @Autowired
    private UserPersonalInfoService userPersonalInfoService;

    @ApiOperation(value = "9-15-01 【v1】更新用户信息【头像】", notes = "支持更换头像")
    @PostMapping(value = "/head-img")
    @ApiVersion(1)
    public Json updateHeadImg(@RequestBody UserHeadImgParam user) {
        Message message = userPersonalInfoService.doUpdateHeadImg(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        } else {
            return ResultUtil.genFailedResult(message.getLastMessage());
        }

    }

    @ApiOperation(value = "9-15-02 【v1】更新用户信息【昵称】", notes = "支持更换昵称")
    @PostMapping(value = "/nickname")
    @ApiVersion(1)
    public Json updateNickname(@RequestBody UserNicknameParam user) {
        Message message = userPersonalInfoService.doUpdateNickname(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        } else {
            return ResultUtil.genFailedResult(message.getLastMessage());
        }
    }

    @ApiOperation(value = "9-15-03 【v1】更新用户信息【生日】", notes = "支持更换生日")
    @PostMapping(value = "/birth")
    @ApiVersion(1)
    public Json updateBirth(@RequestBody UserBirthParam user) {
        Message message = userPersonalInfoService.doUpdateBirth(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        } else {
            return ResultUtil.genFailedResult(message.getLastMessage());
        }
    }

    @ApiOperation(value = "9-15-04 【v1】更新用户信息【家乡】", notes = "支持更换家乡")
    @PostMapping(value = "/hometown")
    @ApiVersion(1)
    public Json updateHometown(@RequestBody UserHomeTownParam user) {
        Message message = userPersonalInfoService.doUpdateHometown(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        } else {
            return ResultUtil.genFailedResult(message.getLastMessage());
        }
    }

    @ApiOperation(value = "9-15-05 【v1】更新用户信息【情感状态】", notes = "支持更换情感状态 0：保密  1：单身  2：恋爱中  3：已婚")
    @PostMapping(value = "/emotion")
    @ApiVersion(1)
    public Json updateEmotion(@RequestBody UserEmotionParam user) {
        Message message = userPersonalInfoService.doUpdateEmotion(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        } else {
            return ResultUtil.genFailedResult(message.getLastMessage());
        }
    }

    @ApiOperation(value = "9-15-06 【v1】更新用户信息【职业】", notes = "支持更换职业")
    @PostMapping(value = "/job")
    @ApiVersion(1)
    public Json updateJob(@RequestBody UserJobParam user) {
        Message message = userPersonalInfoService.doUpdateJob(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        } else {
            return ResultUtil.genFailedResult(message.getLastMessage());
        }
    }

    @ApiOperation(value = "9-15-07 【v1】更新用户信息【个人简介】", notes = "支持更换个人简介")
    @PostMapping(value = "/introduction")
    @ApiVersion(1)
    public Json updateIntroduction(@RequestBody UserIntroductionParam user) {
        Message message = userPersonalInfoService.doUpdatePersonalProfile(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        } else {
            return ResultUtil.genFailedResult(message.getLastMessage());
        }
    }

    @ApiOperation(value = "9-15-08 【v1】更新用户信息【手机】", notes = "1.具体手机号绑定 2.当前手机号一键绑定")
    @PostMapping(value = "/phone")
    @ApiVersion(1)
    public Json updatePhone(@RequestBody UserPhoneParam user, HttpServletRequest request) throws BindException {
        user.setIp(WebUtils.getIpAddr(request));
        Message message = userPersonalInfoService.doUpdateUserPhone(user);
        //绑定手机成功返回手机号
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult(message.getParam("phone"));
        } else {
            //如果绑定时发现绑定了其他手机号，则进行重新登陆
            Integer code = message.getParam("code");
            if (null != code && RespCode.UNAUTHORIZED == code) {
                return ResultUtil.genFailedResult(RespCode.UNAUTHORIZED, message.getLastMessage());
            }
            return ResultUtil.genFailedResult(message.getLastMessage());
        }
    }

    @ApiOperation(value = "9-15-09 【v1】更新用户信息【性别】", notes = "支持更换性别")
    @PostMapping(value = "/sex")
    @ApiVersion(1)
    public Json updateSex(@RequestBody UserSexParam user) {
        Message message = userPersonalInfoService.doUpdateUserSex(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        } else {
            return ResultUtil.genFailedResult(message.getLastMessage());
        }
    }

    @ApiOperation(value = "9-15-10 【v1】得到个人资料页面的用户信息", notes = "包含 头像、昵称、性别、生日、地址、兴趣标签等，原来的接口乱七八糟，不用了")
    @GetMapping(value = "/{userId}")
    @ApiVersion(1)
    public Json<UserPersonalInfoDTO> getPersonalInfo(@PathVariable Long userId) {
        return ResultUtil.genSuccessResult(userPersonalInfoService.getUserPersonalInfo(userId));

    }

    @ApiOperation(value = "9-15-11 【v1】用户完善资料弹窗", notes = "用户资料完善弹窗")
    @GetMapping(value = "/pop/{userId}")
    @ApiVersion(1)
    public Json<Boolean> getCompleteInformationWindow(@PathVariable Long userId) {
        return ResultUtil.genSuccessResult(userPersonalInfoService.getCompleteInformationWindow(userId));
    }

    @ApiOperation(value = "9-15-12 【v1】用户更新微信号", notes = "在个人资料编辑页面更新微信号")
    @PostMapping(value = "/wechat")
    @ApiVersion(1)
    public Json updateWechat(@RequestBody UserWechatParam userWechatParam) {
        Message message = userPersonalInfoService.doUpdateUserWechat(userWechatParam);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        } else {
            return ResultUtil.genFailedResult(message.getLastMessage());
        }
    }

    @ApiOperation(value = "9-15-13 【v1】[新手引导]更新基础资料", notes = "更新生日、头像、昵称、定位、性别")
    @PostMapping(value = "/guide")
    @ApiVersion(1)
    public Json<UserInfoDTO> updateNewbieGuideInfo(@RequestBody NewbieGuideParam newbieGuideParam) {
        Message message = userPersonalInfoService.doUpdateNewbieGuideInfo(newbieGuideParam);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult(message.getParam("user"));
        } else {
            return ResultUtil.genFailedResult(message.getLastMessage());
        }
    }

    @ApiOperation(value = "9-15-14 【v1】修改订单隐私开关状态", notes = "修改订单隐私开关状态")
    @PostMapping(value = "orderPrivacyChange")
    @ApiVersion(1)
    public ResponseJson<Boolean> orderPrivacyChange(@RequestBody OrderPrivacyChangeParam param) {
        return ResponseJson.ok(userPersonalInfoService.orderPrivacyChange(param));
    }

    @ApiOperation(value = "9-15-15 [v1] 用户账号资料引导", notes = "用户账号资料引导",nickname = "耿杨杨")
    @GetMapping("/getAccountMaterialGuide")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "当前用户ID"),
    })
    @ApiVersion(1)
    public ResponseJson<UserAccountMaterialGuideDTO> getAccountMaterialGuide(@RequestParam("userId") Long userId) {
        return ResponseJson.ok(userPersonalInfoService.getAccountMaterialGuide(userId));
    }
}
