package com.bxm.localnews.user.controller;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.h5.ClientVersionDto;
import com.bxm.localnews.user.dto.h5.PublicUserInfoDto;
import com.bxm.localnews.user.enums.AppConst;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.param.UserClipboardParam;
import com.bxm.localnews.user.support.UserEquipmentService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "9-18 用户对外的公开接口")
@RestController
@RequestMapping("{version}/user/public")
@Slf4j
public class UserPublicController {

    private final UserService userService;

    private UserEquipmentService userEquipmentService;


    @Autowired
    public UserPublicController(UserService userService, UserEquipmentService userEquipmentService) {
        this.userService = userService;
        this.userEquipmentService = userEquipmentService;

    }

    @ApiOperation(value = "9-18-01 [v1]获取用户公开信息")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @ApiVersion(1)
    @GetMapping("get")
    public Json<PublicUserInfoDto> get(Long userId) {
        PublicUserInfoDto publicUser = PublicUserInfoDto.builder()
                .userId(userId)
                .build();

        UserInfoDTO userInfo = userService.getUserCache(userId);
        if (null != userInfo
                && null != userInfo.getState()
                && AppConst.USER_STATE.NORMAL == userInfo.getState()) {
            publicUser.setRegUser(true);
        }
        return Json.ok(publicUser);
    }

    @ApiOperation(value = "9-18-02 [v1]获取指定用户客户端信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "targetUserId", value = "查询目标用户ID"),
            @ApiImplicitParam(name = "curVer", value = "[通用参数]客户端当前版本")
    })
    @ApiVersion(1)
    @GetMapping("client/version")
    public Json<ClientVersionDto> clientVersion(Long targetUserId, String curVer) {
        return Json.ok(userEquipmentService.queryClientVersion(targetUserId, curVer));
    }

    @ApiOperation(value = "9-18-03 [v1]上传粘贴板信息", notes = "应用进入首页时，将留存的粘贴板信息上报到服务端进行异步处理，不关心具体的返回值")
    @ApiVersion(1)
    @PostMapping("clipboard")
    public ResponseJson<Boolean> clipboardUpload(@RequestBody UserClipboardParam param) {
        return ResponseJson.ok(userService.clipboardUpload(param));
    }
}
