package com.bxm.localnews.user.controller;

import com.bxm.localnews.user.dto.RelationInfoRspDTO;
import com.bxm.localnews.user.tbk.UserTbkBindService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@Api(tags = "9-20 用户淘宝客绑定相关接口", description = "用户淘宝客绑定相关接口")
@RestController
@RequestMapping("{version}/user/tbk")
public class UserTbkBindController {

    @Autowired
    private UserTbkBindService userTbkBindService;


    @ApiOperation(value = "9-20-1 [v1]绑定用户渠道ID ,会员ID", notes = "绑定用户渠道ID ,会员ID")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "code", value = "用户授权后的code", required = true),
            @ApiImplicitParam(name = "userId", value = "用户Id,等同于淘宝授权回调的state参数", required = true)
    })
    @GetMapping("relation/bind")
    @ApiVersion(1)
    public ResponseJson<RelationInfoRspDTO> relateUserInfo(@RequestParam("userId") Long userId,
                                                           @RequestParam("code") String code) {

        return ResponseJson.ok(userTbkBindService.relateUserInfo(userId, code));
    }

    @ApiOperation(value = "9-20-2 [v1]查看用户是否绑定会员信息接口", notes = "查看用户是否绑定会员信息接口")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户Id", required = true)
    })
    @ApiVersion(1)
    @GetMapping("relation/check")
    public ResponseJson<RelationInfoRspDTO> checkRelation(Long userId){
        return ResponseJson.ok(userTbkBindService.checkRelation(userId));
    }
}
