package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.dto.WithdrawDTO;
import com.bxm.localnews.user.integration.WithdrawIntegrationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "9-05 用户提现相关API", description = "提现配置信息和用户提现")
@RestController
@RequestMapping("api/user/withdraw")
public class UserWithdrawController {

    private final WithdrawIntegrationService withdrawIntegrationService;

    @Autowired
    public UserWithdrawController(WithdrawIntegrationService withdrawIntegrationService) {
        this.withdrawIntegrationService = withdrawIntegrationService;
    }

    /**
     * 接口已废弃，迁移到localnews-biz的payment模块中
     */
    @ApiOperation(value = "9-05-1 [已废弃]获取用户可提现的配置信息列表", notes = "请修改为调用6-03-2")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id")
    })
    @GetMapping("/list")
    @Deprecated
    public Json<WithdrawDTO> getWithDrawList(@RequestParam("userId") Long userId) {
        return Json.ok(withdrawIntegrationService.getWithdrawDto(userId));
    }
}
