/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.user.controller;

import com.bxm.localnews.user.dto.vip.VipActivationResultDTO;
import com.bxm.localnews.user.model.VipCardInfoDTO;
import com.bxm.localnews.user.model.VipInfoDetailDTO;
import com.bxm.localnews.user.model.param.VipQueryParam;
import com.bxm.localnews.user.param.VipActivationCodeParam;
import com.bxm.localnews.user.vip.UserVipService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("{version}/user/vipInfo")
@Api(tags = "9-21 [v1]会员卡相关信息API", description = "会员卡的相关信息")
public class VipUserController {

    private final UserVipService userVipService;

    @Autowired
    public VipUserController(UserVipService userVipService) {
        this.userVipService = userVipService;
    }

    @ApiOperation(value = "9-21-01 [v1]会员卡信息列表", notes = "查询配置的会员卡信息列表")
    @RequestMapping(value = "vipCard", method = RequestMethod.GET)
    @ApiVersion(1)
    public ResponseJson<List<VipCardInfoDTO>> getVipCard() {
        return ResponseJson.ok(userVipService.getVipCardList());
    }

    @ApiOperation(value = "9-21-02 [v1]激活码激活VIP", notes = "如果返回code不等于200，则显示对于的错误提示信息")
    @RequestMapping(value = "vipActivation", method = RequestMethod.POST)
    @ApiVersion(1)
    public ResponseJson<VipActivationResultDTO> vipActivation(@RequestBody VipActivationCodeParam activationCodeParam) {
        return ResponseJson.ok(userVipService.execActivationVipByCode(activationCodeParam, 0));
    }

    @ApiOperation(value = "9-21-03 [v1]激活码激活VIP，站外使用", notes = "如果返回code不等于200，则显示对于的错误提示信息")
    @RequestMapping(value = "public/vipActivation", method = RequestMethod.POST)
    @ApiVersion(1)
    public ResponseJson<VipActivationResultDTO> vipActivationPublic(@RequestBody VipActivationCodeParam activationCodeParam) {
        return ResponseJson.ok(userVipService.execActivationVipByCode(activationCodeParam, 1));
    }

    @ApiOperation(value = "9-21-04 [v1]站外会员卡信息列表", notes = "查询配置的会员卡信息列表")
    @RequestMapping(value = "/public/vipCard", method = RequestMethod.GET)
    @ApiVersion(1)
    public ResponseJson<List<VipCardInfoDTO>> getVipCardPublic() {
        return ResponseJson.ok(userVipService.getVipCardList());
    }

    @ApiOperation(value = "9-21-05 [v2]站内获取VIP信息", notes = "站内获取VIP信息")
    @RequestMapping(value = "/vipDetail", method = RequestMethod.GET)
    @ApiVersion(2)
    public ResponseJson<VipInfoDetailDTO> get(@Validated VipQueryParam param) {
        return ResponseJson.ok(userVipService.getVipDetail(param));
    }

    @ApiOperation(value = "9-21-05 [v1]站内获取VIP信息", notes = "站内获取VIP信息", hidden = true)
    @RequestMapping(value = "/vipDetail", method = RequestMethod.GET)
    @ApiVersion(1)
    public ResponseJson<VipInfoDetailDTO> getVipCardPublic(@RequestParam("userId") Long userId) {
        VipQueryParam param = new VipQueryParam();
        param.setUserId(userId);
        return ResponseJson.ok(userVipService.getVipDetail(param));
    }
}
