package com.bxm.localnews.user.controller;

import com.bxm.localnews.user.account.VirtualService;
import com.bxm.localnews.user.dto.UserVirtualAdminDTO;
import com.bxm.localnews.user.dto.UserVirtualDTO;
import com.bxm.localnews.user.dto.UserVirtualLoginMetaDTO;
import com.bxm.localnews.user.param.UserVirtualAddParam;
import com.bxm.localnews.user.param.UserVirtualAdminParam;
import com.bxm.localnews.user.param.UserVirtualLoginParam;
import com.bxm.localnews.user.param.UserVirtualParam;
import com.bxm.localnews.user.vo.LoginMeta;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.Collections;
import java.util.List;

/**
 * @author: gengyy
 * @create: 2020-10-22 19:36
 */
@Api(tags = "9-23 马甲号相关API")
@RestController
@RequestMapping("{version}/user/virtual")
@AllArgsConstructor
public class VirtualController {

    private VirtualService virtualService;

    @ApiOperation(value = "9-23-1 【v1】马甲管理下的马甲号查询列表", notes = "马甲管理下的马甲号查询列表",nickname = "耿杨杨")
    @GetMapping(value = "/getAdminVirtualList")
    @ApiVersion(1)
    public ResponseJson<List<UserVirtualAdminDTO>> getAdminVirtualList(UserVirtualAdminParam userVisitParam) {
        return ResponseJson.ok(virtualService.getAdminVirtualList(userVisitParam));
    }

    @ApiOperation(value = "9-23-2 【v1】马甲号查询列表", notes = "马甲号查询列表",nickname = "耿杨杨")
    @GetMapping(value = "/getVirtualList")
    @ApiVersion(1)
    public ResponseJson<List<UserVirtualDTO>> getVirtualList(UserVirtualParam userVisitParam) {
        return ResponseJson.ok(virtualService.getVirtualList(userVisitParam));
    }

    @ApiOperation(value = "9-23-3 【v1】添加马甲号到马甲管理员下", notes = "添加马甲号到马甲管理员下",nickname = "耿杨杨")
    @PostMapping(value = "/addVirtualToAdminAccount")
    @ApiVersion(1)
    public ResponseJson<Boolean> addVirtualToAdminAccount(@RequestBody UserVirtualAddParam userVisitParam) {
        return ResponseJson.ok(virtualService.addVirtualToAdminAccount(userVisitParam));
    }

    @ApiOperation(value = "9-23-4 【v1】马甲号切换登陆", notes = "添加马甲号到马甲管理员下",nickname = "耿杨杨")
    @PostMapping(value = "/virtualToLogin")
    @ApiVersion(1)
    public ResponseJson<UserVirtualLoginMetaDTO> virtualToLogin(@RequestBody @Valid UserVirtualLoginParam userVisitParam, HttpServletRequest request) {
        String ip = WebUtils.getIpAddr(request);
        userVisitParam.setIp(ip);
        Message message = virtualService.virtualToLogin(userVisitParam);
        if (!message.isSuccess()) {
           return ResponseJson.build(message);
        }
        return ResponseJson.ok(message.getParam("meta"));
    }


}
