package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.attribute.UserVisitService;
import com.bxm.localnews.user.dto.UserEntertranningDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.UserVisitDTO;
import com.bxm.localnews.user.param.UserVisitParam;
import com.bxm.localnews.user.support.VirtualUserService;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "9-12 访客相关API", description = "用户访客相关")
@RestController
@RequestMapping("api/user/visitor")
public class VisitorController extends BaseController {

    @Autowired
    private UserVisitService userVisitService;
    @Autowired
    private VirtualUserService virtualUserService;

    @ApiOperation(value = "9-12-1 用户访问列表", notes = "按日期分页，例如pageSize传3，则每次给3个日期的访客列表，数量不定")
    @GetMapping(value = "list")
    public Json<List<UserVisitDTO>> listVisitor(UserVisitParam userVisitParam) {
        if (null == userVisitParam.getUserId()) {
            return ResultUtil.genFailedResult("用户id不能为空");
        }
        return ResultUtil.genSuccessResult(userVisitService.listUserVisit(userVisitParam));
    }

    @ApiOperation(value = "9-12-2 批量虚拟用户访问，运营专用，请勿调用")
    @ApiImplicitParams({
        @ApiImplicitParam(name = "userId", value = "用户ID"),
        @ApiImplicitParam(name = "num", value = "数量")
    })
    @PostMapping(value = "public/virtualVisit")
    public Json virtualVisit(@RequestParam(name = "userId") Long userId,
        @RequestParam(name = "num") Integer num) {
        userVisitService.virtualVisit(userId, num);
        return ResultUtil.genSuccessResult();
    }
    @ApiOperation(value = "9-12-3 获取虚拟用户", notes = "随机获取一定量的虚拟用户")
    @PostMapping("/getVirtualUserList")
    public ResponseJson<List<UserEntertranningDTO>> getVirtualUserList(@RequestParam("num") Integer num) {
        return ResponseJson.ok(virtualUserService.listEntertaining(num));
    }
    @ApiOperation(value = "9-12-4 站外获取虚拟用户", notes = "随机获取一定量的虚拟用户")
    @PostMapping("public/getVirtualUserList")
    public ResponseJson<List<UserEntertranningDTO>> getVirtualUserPublicList(@RequestParam("num") Integer num) {
        return ResponseJson.ok(virtualUserService.listEntertaining(num));
    }
}
