package com.bxm.localnews.user.controller.activity;

import com.bxm.localnews.user.activity.UserInviteCashAwardService;
import com.bxm.localnews.user.model.dto.ActivityAreaConfigDTO;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author liujia
 * @date 12/22/20 6:07 PM
 **/
@Api(tags = "9-27 用户拉新活动相关接口")
@RestController
@RequestMapping("{version}/user/activity")
public class ActivityController {

    private final UserInviteCashAwardService userInviteCashAwardService;

    @Autowired
    public ActivityController(UserInviteCashAwardService userInviteCashAwardService) {
        this.userInviteCashAwardService = userInviteCashAwardService;
    }

    @ApiOperation(value = "9-27-1 获取地区开通的现金拉新活动信息", notes = "如果返回null则表示当前地区未开通活动")
    @ApiImplicitParam(name = "areaCode", value = "地区编码")
    @GetMapping("config")
    @ApiVersion(1)
    public ResponseJson<ActivityAreaConfigDTO> getActivityConfig(@RequestParam("areaCode") String areaCode) {
        return ResponseJson.ok(userInviteCashAwardService.getActivityAreaConfig(areaCode));
    }
}
