package com.bxm.localnews.user.controller.earnings;

import com.bxm.localnews.user.earnings.UserEarningsService;
import com.bxm.localnews.user.model.param.earnings.UserEarningsParam;
import com.bxm.localnews.user.model.vo.earnings.UserEarningsListVO;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author lowi
 * @date 2020/12/11 9:59
 */
@Api(tags = "9-25 用户收益相关接口")
@RestController
@RequestMapping("{version}/user/earnings")
public class UserEarningsController {

    private final UserEarningsService userEarningsService;

    @Autowired
    public UserEarningsController(UserEarningsService userEarningsService) {
        this.userEarningsService = userEarningsService;
    }

    @GetMapping("list")
    @ApiOperation(value = "9-25-01 [v1] 我的收益列表", notes = "获取我的收益", nickname = "耿杨杨")
    @ApiVersion(1)
    public ResponseJson<PageWarper<UserEarningsListVO>> getUserEarningsList(@Validated UserEarningsParam param) {
        return ResponseJson.ok(userEarningsService.getUserEarningsList(param));
    }

}
