package com.bxm.localnews.user.controller.hotpost;

import com.bxm.localnews.user.hotpost.HotPostRankService;
import com.bxm.localnews.user.model.vo.hotpost.HotPostRankInfoVO;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/1/12 4:54 下午
 */
@Api(tags = "9-28 热文帖子排行榜相关接口")
@RestController
@RequestMapping("{version}/user/hotPost")
@AllArgsConstructor
public class HotPostRankController {

    private final HotPostRankService hotPostRankService;

    @ApiOperation(value = "9-28-1 [v1]热文帖子排行榜接口", notes = "热门帖子排行榜接口")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCode", value = "区域编码", required = true),
            @ApiImplicitParam(name = "userId", value = "用户Id", required = true)
    })
    @GetMapping("/rankInfo")
    @ApiVersion(1)
    public ResponseJson<HotPostRankInfoVO> rankInfo(@RequestParam("userId") Long userId,
                                                    @RequestParam("areaCode") String areaCode) {
        return ResponseJson.ok(hotPostRankService.getRankInfo(userId, areaCode));
    }
}