package com.bxm.localnews.user.controller.hotpost;

import com.bxm.localnews.user.hotpost.HotPostRankService;
import com.bxm.newidea.component.vo.ResponseJson;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 手动触发热文奖励排行榜
 *
 * @author wzy
 * @version 1.0
 * @date 2021/1/22 5:32 下午
 */
@RestController
@RequestMapping("{version}/user/hotPost/test")
@AllArgsConstructor
public class HotPostRankTestController {
    private final HotPostRankService hotPostRankService;

    @GetMapping("refresh")
    public ResponseJson refreshRank() {
        hotPostRankService.refreshPostShareCashRank();
        return ResponseJson.ok().build();
    }
}