package com.bxm.localnews.user.controller.invite;

import com.bxm.localnews.user.model.param.talent.InviteBindParam;
import com.bxm.localnews.user.talent.TalentInviteRecordService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wzy
 * @version 1.0
 * @date 2020/12/22 4:54 下午
 */
@Api(tags = "9-26 用户临时绑定关系相关接口")
@RestController
@RequestMapping("{version}/user/temp/invite")
@AllArgsConstructor
public class UserInviteRecordController {

    private final TalentInviteRecordService talentInviteRecordService;

    @ApiOperation(value = "9-26-01 [v1] 建立新的用户临时绑定关系", notes = "建立新的用户临时绑定关系", nickname = "王志远")
    @PostMapping("/bind")
    @ApiVersion(1)
    public ResponseJson bind(@RequestBody InviteBindParam param) {
        talentInviteRecordService.addTalentInviteRecord(param);
        return ResponseJson.ok().build();
    }
}