package com.bxm.localnews.user.controller.talent;

import com.bxm.localnews.user.model.param.talent.GroupTalentListQueryParam;
import com.bxm.localnews.user.model.param.talent.TalentRegisterParam;
import com.bxm.localnews.user.model.vo.talent.TalentGroupInfoVO;
import com.bxm.localnews.user.model.vo.talent.TalentGroupListVO;
import com.bxm.localnews.user.model.vo.talent.TalentInviteVO;
import com.bxm.localnews.user.model.vo.talent.TalentRegisterResultVO;
import com.bxm.localnews.user.talent.UserTalentService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

/**
 * 达人相关接口
 *
 * @author wzy
 * @version 1.0
 * @date 2020/12/10 9:44 上午
 */
@Api(tags = "9-24 达人相关接口")
@RestController
@RequestMapping("{version}/user/talent")
public class TalentController {

    private final UserTalentService userTalentService;

    public TalentController(UserTalentService userTalentService) {
        this.userTalentService = userTalentService;
    }

    @ApiOperation(value = "9-24-01 [v1] 获取我的团队信息接口", notes = "获取我的团队信息接口", nickname = "王志远")
    @GetMapping("/groupInfo")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "当前用户ID"),
    })
    @ApiVersion(1)
    public ResponseJson<TalentGroupInfoVO> getGroupInfo(@RequestParam("userId") Long userId) {
        return ResponseJson.ok(userTalentService.getGroupInfo(userId));
    }

    @ApiOperation(value = "9-24-03 [v1] 获取团队的成员列表", notes = "获取团队的成员列表", nickname = "王志远")
    @GetMapping("/groupTalentList")
    @ApiVersion(1)
    public ResponseJson<PageWarper<TalentGroupListVO>> getGroupTalentList(GroupTalentListQueryParam param) {
        return ResponseJson.ok(userTalentService.getGroupTalentList(param));
    }

    @ApiOperation(value = "9-24-04 [v1] 注册达人", notes = "注册达人", nickname = "王志远")
    @PostMapping("/register")
    @ApiVersion(1)
    public ResponseJson<TalentRegisterResultVO> register(@RequestBody TalentRegisterParam talentRegisterParam) {
        return ResponseJson.ok(userTalentService.register(talentRegisterParam));
    }

    @ApiOperation(value = "9-24-05 [v1] 是否已经是达人", notes = "是否已经是达人", nickname = "王志远")
    @GetMapping("/beComeTalent")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "当前用户ID"),
    })
    @ApiVersion(1)
    public ResponseJson<TalentInviteVO> becomeTalent(@RequestParam("userId") Long userId) {
        return ResponseJson.ok(userTalentService.becomeTalent(userId));
    }
}