/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.attribute.UserPersonalInfoService;
import com.bxm.localnews.user.dto.UserAccountMaterialGuideDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.UserPersonalInfoDTO;
import com.bxm.localnews.user.param.NewbieGuideParam;
import com.bxm.localnews.user.param.OrderPrivacyChangeParam;
import com.bxm.localnews.user.param.UserBirthParam;
import com.bxm.localnews.user.param.UserEmotionParam;
import com.bxm.localnews.user.param.UserHeadImgParam;
import com.bxm.localnews.user.param.UserHomeTownParam;
import com.bxm.localnews.user.param.UserIntroductionParam;
import com.bxm.localnews.user.param.UserJobParam;
import com.bxm.localnews.user.param.UserNicknameParam;
import com.bxm.localnews.user.param.UserPhoneParam;
import com.bxm.localnews.user.param.UserSexParam;
import com.bxm.localnews.user.param.UserWechatParam;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"9-15 \u7528\u6237\u4e2a\u4eba\u8d44\u6599\u76f8\u5173API"})
@RestController
@RequestMapping(value={"{version}/user/personal-info"})
public class UserPersonalInfoController {
    @Autowired
    private UserPersonalInfoService userPersonalInfoService;

    @ApiOperation(value="9-15-01 \u3010v1\u3011\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3010\u5934\u50cf\u3011", notes="\u652f\u6301\u66f4\u6362\u5934\u50cf")
    @PostMapping(value={"/head-img"})
    @ApiVersion(value=1)
    public Json updateHeadImg(@RequestBody UserHeadImgParam user) {
        Message message = this.userPersonalInfoService.doUpdateHeadImg(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="9-15-02 \u3010v1\u3011\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3010\u6635\u79f0\u3011", notes="\u652f\u6301\u66f4\u6362\u6635\u79f0")
    @PostMapping(value={"/nickname"})
    @ApiVersion(value=1)
    public Json updateNickname(@RequestBody UserNicknameParam user) {
        Message message = this.userPersonalInfoService.doUpdateNickname(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="9-15-03 \u3010v1\u3011\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3010\u751f\u65e5\u3011", notes="\u652f\u6301\u66f4\u6362\u751f\u65e5")
    @PostMapping(value={"/birth"})
    @ApiVersion(value=1)
    public Json updateBirth(@RequestBody UserBirthParam user) {
        Message message = this.userPersonalInfoService.doUpdateBirth(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="9-15-04 \u3010v1\u3011\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3010\u5bb6\u4e61\u3011", notes="\u652f\u6301\u66f4\u6362\u5bb6\u4e61")
    @PostMapping(value={"/hometown"})
    @ApiVersion(value=1)
    public Json updateHometown(@RequestBody UserHomeTownParam user) {
        Message message = this.userPersonalInfoService.doUpdateHometown(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="9-15-05 \u3010v1\u3011\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3010\u60c5\u611f\u72b6\u6001\u3011", notes="\u652f\u6301\u66f4\u6362\u60c5\u611f\u72b6\u6001 0\uff1a\u4fdd\u5bc6  1\uff1a\u5355\u8eab  2\uff1a\u604b\u7231\u4e2d  3\uff1a\u5df2\u5a5a")
    @PostMapping(value={"/emotion"})
    @ApiVersion(value=1)
    public Json updateEmotion(@RequestBody UserEmotionParam user) {
        Message message = this.userPersonalInfoService.doUpdateEmotion(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="9-15-06 \u3010v1\u3011\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3010\u804c\u4e1a\u3011", notes="\u652f\u6301\u66f4\u6362\u804c\u4e1a")
    @PostMapping(value={"/job"})
    @ApiVersion(value=1)
    public Json updateJob(@RequestBody UserJobParam user) {
        Message message = this.userPersonalInfoService.doUpdateJob(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="9-15-07 \u3010v1\u3011\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3010\u4e2a\u4eba\u7b80\u4ecb\u3011", notes="\u652f\u6301\u66f4\u6362\u4e2a\u4eba\u7b80\u4ecb")
    @PostMapping(value={"/introduction"})
    @ApiVersion(value=1)
    public Json updateIntroduction(@RequestBody UserIntroductionParam user) {
        Message message = this.userPersonalInfoService.doUpdatePersonalProfile(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="9-15-08 \u3010v1\u3011\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3010\u624b\u673a\u3011", notes="1.\u5177\u4f53\u624b\u673a\u53f7\u7ed1\u5b9a 2.\u5f53\u524d\u624b\u673a\u53f7\u4e00\u952e\u7ed1\u5b9a")
    @PostMapping(value={"/phone"})
    @ApiVersion(value=1)
    public Json updatePhone(@RequestBody UserPhoneParam user, HttpServletRequest request) throws BindException {
        user.setIp(WebUtils.getIpAddr((HttpServletRequest)request));
        Message message = this.userPersonalInfoService.doUpdateUserPhone(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult((Object)message.getParam("phone"));
        }
        Integer code = (Integer)message.getParam("code");
        if (null != code && RespCode.UNAUTHORIZED == code) {
            return ResultUtil.genFailedResult((int)RespCode.UNAUTHORIZED, (String)message.getLastMessage());
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="9-15-09 \u3010v1\u3011\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3010\u6027\u522b\u3011", notes="\u652f\u6301\u66f4\u6362\u6027\u522b")
    @PostMapping(value={"/sex"})
    @ApiVersion(value=1)
    public Json updateSex(@RequestBody UserSexParam user) {
        Message message = this.userPersonalInfoService.doUpdateUserSex(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="9-15-10 \u3010v1\u3011\u5f97\u5230\u4e2a\u4eba\u8d44\u6599\u9875\u9762\u7684\u7528\u6237\u4fe1\u606f", notes="\u5305\u542b \u5934\u50cf\u3001\u6635\u79f0\u3001\u6027\u522b\u3001\u751f\u65e5\u3001\u5730\u5740\u3001\u5174\u8da3\u6807\u7b7e\u7b49\uff0c\u539f\u6765\u7684\u63a5\u53e3\u4e71\u4e03\u516b\u7cdf\uff0c\u4e0d\u7528\u4e86")
    @GetMapping(value={"/{userId}"})
    @ApiVersion(value=1)
    public Json<UserPersonalInfoDTO> getPersonalInfo(@PathVariable Long userId) {
        return ResultUtil.genSuccessResult((Object)this.userPersonalInfoService.getUserPersonalInfo(userId));
    }

    @ApiOperation(value="9-15-11 \u3010v1\u3011\u7528\u6237\u5b8c\u5584\u8d44\u6599\u5f39\u7a97", notes="\u7528\u6237\u8d44\u6599\u5b8c\u5584\u5f39\u7a97")
    @GetMapping(value={"/pop/{userId}"})
    @ApiVersion(value=1)
    public Json<Boolean> getCompleteInformationWindow(@PathVariable Long userId) {
        return ResultUtil.genSuccessResult((Object)this.userPersonalInfoService.getCompleteInformationWindow(userId));
    }

    @ApiOperation(value="9-15-12 \u3010v1\u3011\u7528\u6237\u66f4\u65b0\u5fae\u4fe1\u53f7", notes="\u5728\u4e2a\u4eba\u8d44\u6599\u7f16\u8f91\u9875\u9762\u66f4\u65b0\u5fae\u4fe1\u53f7")
    @PostMapping(value={"/wechat"})
    @ApiVersion(value=1)
    public Json updateWechat(@RequestBody UserWechatParam userWechatParam) {
        Message message = this.userPersonalInfoService.doUpdateUserWechat(userWechatParam);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="9-15-13 \u3010v1\u3011[\u65b0\u624b\u5f15\u5bfc]\u66f4\u65b0\u57fa\u7840\u8d44\u6599", notes="\u66f4\u65b0\u751f\u65e5\u3001\u5934\u50cf\u3001\u6635\u79f0\u3001\u5b9a\u4f4d\u3001\u6027\u522b")
    @PostMapping(value={"/guide"})
    @ApiVersion(value=1)
    public Json<UserInfoDTO> updateNewbieGuideInfo(@RequestBody NewbieGuideParam newbieGuideParam) {
        Message message = this.userPersonalInfoService.doUpdateNewbieGuideInfo(newbieGuideParam);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult((Object)message.getParam("user"));
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="9-15-14 \u3010v1\u3011\u4fee\u6539\u8ba2\u5355\u9690\u79c1\u5f00\u5173\u72b6\u6001", notes="\u4fee\u6539\u8ba2\u5355\u9690\u79c1\u5f00\u5173\u72b6\u6001")
    @PostMapping(value={"orderPrivacyChange"})
    @ApiVersion(value=1)
    public ResponseJson<Boolean> orderPrivacyChange(@RequestBody OrderPrivacyChangeParam param) {
        return ResponseJson.ok((Object)this.userPersonalInfoService.orderPrivacyChange(param));
    }

    @ApiOperation(value="9-15-15 [v1] \u7528\u6237\u8d26\u53f7\u8d44\u6599\u5f15\u5bfc", notes="\u7528\u6237\u8d26\u53f7\u8d44\u6599\u5f15\u5bfc", nickname="\u803f\u6768\u6768")
    @GetMapping(value={"/getAccountMaterialGuide"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u5f53\u524d\u7528\u6237ID")})
    @ApiVersion(value=1)
    public ResponseJson<UserAccountMaterialGuideDTO> getAccountMaterialGuide(@RequestParam(value="userId") Long userId) {
        return ResponseJson.ok((Object)this.userPersonalInfoService.getAccountMaterialGuide(userId));
    }
}

