package com.bxm.localnews.user.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * 用户列表佣金类型
 *
 * @author lowi
 * @date 2020/12/15 19:45
 */
@Getter
public enum UserEarningsShowTypeEnum {

    /**
     * 默认不存在
     */
    DEFAULT(-1, ""),

    /**
     * 淘宝返佣
     */
    TB_COMMISSION(1, "淘宝返佣"),

    /**
     * 外卖返佣
     */
    TAKE_OUT_REBATE_COMMISSION(2, "外卖返佣"),

    /**
     * 商品返佣
     */
    GOODS_COMMISSION(3, "商品返佣"),

    /**
     * 开卡返佣
     */
    VIP_COMMISSION(4, "开卡返佣"),

    /**
     * 平台奖励金
     */
    PLAT_FROM_REWARD(5, "平台奖励金"),
    ;

    private Integer type;

    private String desc;

    UserEarningsShowTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static UserEarningsShowTypeEnum get(Integer type) {
        for (UserEarningsShowTypeEnum earningsShowTypeEnum : values()) {
            if (Objects.equals(type, earningsShowTypeEnum.getType())) {
                return earningsShowTypeEnum;
            }
        }
        return UserEarningsShowTypeEnum.DEFAULT;
    }
}
