package com.bxm.localnews.user.enums;

import lombok.Getter;

/**
 * 用户收益枚举列
 *
 * @author lowi
 * @date 2020/12/15 18:51
 */
@Getter
public enum UserEarningsTypeEnum {
    /**
     * earningsType为收益具体类型
     * earningsShowType列表收益需要展示的类型，对应UserEarningsTypeEnum枚举类
     * 10开头 后面增加数据 也不会产生顺序混乱的问题除非一个大类型出现了大于10个
     */
    //默认类型不做处理
    DEFAULT(-1, "", -1),
    TB_SELF_SELL_COMMISSION(10, "淘宝自购返佣", 1),
    TB_SHARE_COMMISSION(11, "淘宝分享返佣", 1),
    TB_TEAM_COMMISSION(12, "淘宝团队返佣", 1),
    ELM_SELF_SELL_COMMISSION(20, "饿了吗自购返佣", 2),
    ELM_SHARE_COMMISSION(21, "饿了吗分享返佣", 2),
    MEITUAN_COMMISSION(22, "美团自购返佣", 2),
    GOODS_SELF_SELL_COMMISSION(30, "商品自购返佣", 3),
    GOODS_SHARE_COMMISSION(31, "商品分享返佣", 3),
    GOODS_TEAM_COMMISSION(32, "商品团队分佣", 3),
    VIP_SHARE_COMMISSION(40, "邀请开卡VIP返佣", 4),
    POST_REWARD(50, "爆料有奖奖励金--帖子奖励", 5),
    FRIENDS_REGISTER_REWARD(51, "好友注册奖励", 5),
    FRIENDS_POST_REWARD(52, "好友发帖奖励", 5),
    /**
     * 3.11.0 新增
     */
    SHARE_HOT_POST(53, "分享热文收益", 5),
    ;

    /**
     * 收益裂隙
     */
    private Integer earningsType;

    private String desc;

    /**
     * 列表收益需要展示标题的类型
     */
    private Integer earningsShowTitleType;

    UserEarningsTypeEnum(Integer earningsType, String desc, Integer earningsShowTitleType) {
        this.earningsType = earningsType;
        this.desc = desc;
        this.earningsShowTitleType = earningsShowTitleType;
    }

    public static UserEarningsTypeEnum getType(Integer type) {
        for (UserEarningsTypeEnum userEarningsTypeEnum : values()) {
            if (type.equals(userEarningsTypeEnum.getEarningsType())) {
                return userEarningsTypeEnum;
            }
        }
        return UserEarningsTypeEnum.DEFAULT;
    }
}
