package com.bxm.localnews.user.param;

import com.bxm.localnews.user.vo.RecommendNative;
import com.bxm.newidea.component.vo.PageParam;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.SuperBuilder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Data
@Builder
public class NativeRecommendContext extends PageParam {

    @ApiModelProperty("筛选（可选）->性别 0：未知  1：男  2：女")
    private Byte sex;

    @ApiModelProperty("筛选（可选）->最小年龄")
    private Byte minAge;

    @ApiModelProperty("筛选（可选）->最大年龄")
    private Byte maxAge;

    @ApiModelProperty("筛选（可选）->所属行业")
    private Long industryId;

    @Builder.Default
    private Byte hasSameCity = 1;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("纬度")
    private String lat;

    @ApiModelProperty("经度")
    private String lon;

    @ApiModelProperty("当前定位城市地区编码")
    private String currentAreaCode;

    @ApiModelProperty(value = "动作参数(2上划,1下拉)", required = true)
    private Integer actionType;

    @ApiModelProperty("推荐类型， NORMAL：普通的本地人推荐  FILTER：筛选推荐 OTHER：其他推荐   备注：" +
            "NORMAL：平常在xx人栏目得到的列表 下拉、上划都传NORMAL" +
            "FILTER：点筛选之后得到的列表，（注意）有数据的情况：下拉、上划都传FILTER" +
            "OTHER：如果点筛选之后，没有命中数据，则会出现<其他推荐>栏目，这时候（注意） 下拉则传FILTER，上划则传OTHER ")
    private String recommendCategory;

    /**
     * 推荐结果
     */
    @Builder.Default
    private List<RecommendNative> result = new ArrayList<>();

    /**
     * 执行过程中的参数map
     */
    @Builder.Default
    private Map<String, Object> paramMap = Maps.newHashMap();

    /**
     * 调用过程中添加参数
     *
     * @param key   参数的键值
     * @param value 键值对应的值
     */
    public NativeRecommendContext addParam(String key, Object value) {
        this.paramMap.put(key, value);
        return this;
    }

    /**
     * 获取消息传递的参数信息
     *
     * @return 参数MAP
     */
    public <T> T getParam(String key) {
        return (T) this.paramMap.get(key);
    }

}
