package com.bxm.localnews.user.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component
@ConfigurationProperties("recommend.config")
@Data
public class RecommendProperties {

    /**
     * 权值分配
     */
    private Map<String,String> weight;

    /**
     * js代码，用于计算分配于哪个桶
     */
    private Map<String, String> formula;

    /**
     * 推荐列表中忽视的用户id
     */
    private List<Long> ignoreUserList;

    /**
     * 缓存清除时间间隔
     */
    private Integer cacheInterval = 2 * 60 * 60;

}
